/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import javax.annotation.Nullable;
import org.sonar.api.utils.log.LogInterceptors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.LoggerLevel;

abstract class BaseLogger
implements Logger {
    BaseLogger() {
    }

    @Override
    public void trace(String msg) {
        LogInterceptors.get().log(LoggerLevel.TRACE, msg);
        this.doTrace(msg);
    }

    @Override
    public void trace(String pattern, @Nullable Object arg) {
        LogInterceptors.get().log(LoggerLevel.TRACE, pattern, arg);
        this.doTrace(pattern, arg);
    }

    @Override
    public void trace(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        LogInterceptors.get().log(LoggerLevel.TRACE, msg, arg1, arg2);
        this.doTrace(msg, arg1, arg2);
    }

    @Override
    public void trace(String msg, Object ... args2) {
        LogInterceptors.get().log(LoggerLevel.TRACE, msg, args2);
        this.doTrace(msg, args2);
    }

    @Override
    public void debug(String msg) {
        LogInterceptors.get().log(LoggerLevel.DEBUG, msg);
        this.doDebug(msg);
    }

    @Override
    public void debug(String pattern, @Nullable Object arg) {
        LogInterceptors.get().log(LoggerLevel.DEBUG, pattern, arg);
        this.doDebug(pattern, arg);
    }

    @Override
    public void debug(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        LogInterceptors.get().log(LoggerLevel.DEBUG, msg, arg1, arg2);
        this.doDebug(msg, arg1, arg2);
    }

    @Override
    public void debug(String msg, Object ... args2) {
        LogInterceptors.get().log(LoggerLevel.DEBUG, msg, args2);
        this.doDebug(msg, args2);
    }

    @Override
    public void info(String msg) {
        LogInterceptors.get().log(LoggerLevel.INFO, msg);
        this.doInfo(msg);
    }

    @Override
    public void info(String msg, @Nullable Object arg) {
        LogInterceptors.get().log(LoggerLevel.INFO, msg, arg);
        this.doInfo(msg, arg);
    }

    @Override
    public void info(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        LogInterceptors.get().log(LoggerLevel.INFO, msg, arg1, arg2);
        this.doInfo(msg, arg1, arg2);
    }

    @Override
    public void info(String msg, Object ... args2) {
        LogInterceptors.get().log(LoggerLevel.INFO, msg, args2);
        this.doInfo(msg, args2);
    }

    @Override
    public void warn(String msg) {
        LogInterceptors.get().log(LoggerLevel.WARN, msg);
        this.doWarn(msg);
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        LogInterceptors.get().log(LoggerLevel.WARN, msg, throwable);
        this.doWarn(msg, throwable);
    }

    @Override
    public void warn(String msg, @Nullable Object arg) {
        LogInterceptors.get().log(LoggerLevel.WARN, msg, arg);
        this.doWarn(msg, arg);
    }

    @Override
    public void warn(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        LogInterceptors.get().log(LoggerLevel.WARN, msg, arg1, arg2);
        this.doWarn(msg, arg1, arg2);
    }

    @Override
    public void warn(String msg, Object ... args2) {
        LogInterceptors.get().log(LoggerLevel.WARN, msg, args2);
        this.doWarn(msg, args2);
    }

    @Override
    public void error(String msg) {
        LogInterceptors.get().log(LoggerLevel.ERROR, msg);
        this.doError(msg);
    }

    @Override
    public void error(String msg, @Nullable Object arg) {
        LogInterceptors.get().log(LoggerLevel.ERROR, msg, arg);
        this.doError(msg, arg);
    }

    @Override
    public void error(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        LogInterceptors.get().log(LoggerLevel.ERROR, msg, arg1, arg2);
        this.doError(msg, arg1, arg2);
    }

    @Override
    public void error(String msg, Object ... args2) {
        LogInterceptors.get().log(LoggerLevel.ERROR, msg, args2);
        this.doError(msg, args2);
    }

    @Override
    public void error(String msg, Throwable thrown) {
        LogInterceptors.get().log(LoggerLevel.ERROR, msg, thrown);
        this.doError(msg, thrown);
    }

    abstract void doTrace(String var1);

    abstract void doTrace(String var1, @Nullable Object var2);

    abstract void doTrace(String var1, @Nullable Object var2, @Nullable Object var3);

    abstract void doTrace(String var1, Object ... var2);

    abstract void doDebug(String var1);

    abstract void doDebug(String var1, @Nullable Object var2);

    abstract void doDebug(String var1, @Nullable Object var2, @Nullable Object var3);

    abstract void doDebug(String var1, Object ... var2);

    abstract void doInfo(String var1);

    abstract void doInfo(String var1, @Nullable Object var2);

    abstract void doInfo(String var1, @Nullable Object var2, @Nullable Object var3);

    abstract void doInfo(String var1, Object ... var2);

    abstract void doWarn(String var1);

    abstract void doWarn(String var1, Throwable var2);

    abstract void doWarn(String var1, @Nullable Object var2);

    abstract void doWarn(String var1, @Nullable Object var2, @Nullable Object var3);

    abstract void doWarn(String var1, Object ... var2);

    abstract void doError(String var1);

    abstract void doError(String var1, @Nullable Object var2);

    abstract void doError(String var1, @Nullable Object var2, @Nullable Object var3);

    abstract void doError(String var1, Object ... var2);

    abstract void doError(String var1, Throwable var2);

    void log(LoggerLevel level, String msg) {
        switch (level) {
            case TRACE: {
                this.trace(msg);
                break;
            }
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
                break;
            }
            case ERROR: {
                this.error(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LoggerLevel value: " + (Object)((Object)level));
            }
        }
    }
}

