/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.util;

import com.bitegarden.sonar.plugins.report.pdf.Fonts;
import com.bitegarden.sonar.plugins.report.util.ParamUtils;
import es.sonarqube.api.SonarQubeProject;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfUtils.class);
    public static final String LABELS_COLOR = "#807D78";
    public static final List<String> METRIC_KEYS = Arrays.asList("reliability_rating", "new_reliability_rating", "bugs", "new_bugs", "security_rating", "new_security_rating", "vulnerabilities", "new_vulnerabilities", "security_hotspots", "new_security_hotspots", "sqale_rating", "new_maintainability_rating", "code_smells", "new_code_smells", "tests", "duplicated_blocks", "duplicated_lines_density", "new_duplicated_lines_density", "ncloc", "comment_lines_density", "violations", "coverage", "new_coverage", "blocker_violations", "new_blocker_violations", "critical_violations", "new_critical_violations", "function_complexity", "sqale_debt_ratio", "new_sqale_debt_ratio", "sqale_index", "duplicated_lines", "lines", "comment_lines");

    private PdfUtils() {
    }

    public static PDType0Font getFont(PDDocument pDDocument, String string) throws IOException {
        return PDType0Font.load(pDDocument, PdfUtils.class.getResourceAsStream(string));
    }

    public static void generateSimpleHeader(PDPageContentStream pDPageContentStream, SonarQubeProject sonarQubeProject, String string, Fonts fonts, ResourceBundle resourceBundle) throws IOException {
        LOGGER.trace("Generating simple header...");
        String string2 = sonarQubeProject.getName();
        String string3 = sonarQubeProject.getLastAnalysis();
        String string4 = resourceBundle.getString("reporting.pdf.report.project.version.label");
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string2, 53, 742);
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string3, 458, 742);
        PdfUtils.writeProjectVersionInfo(sonarQubeProject, fonts, string4, pDPageContentStream, 370, 742, false);
        if (string == null) {
            string = sonarQubeProject.getMainBranch().getName();
        }
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string, 314, 742);
        LOGGER.trace("Header Done!");
    }

    public static void drawImage(PDDocument pDDocument, PDPageContentStream pDPageContentStream, BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        PdfUtils.drawIcon(pDDocument, pDPageContentStream, bufferedImage, n, n2, n3, n4);
    }

    public static void drawIcon(PDDocument pDDocument, PDPageContentStream pDPageContentStream, String string, int n, int n2, int n3, int n4) {
        try {
            URL uRL = new URL(string);
            BufferedImage bufferedImage = ImageIO.read(uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            PDImageXObject pDImageXObject = PDImageXObject.createFromByteArray(pDDocument, byArray, "icon");
            pDPageContentStream.drawImage(pDImageXObject, (float)n, (float)n2, (float)n3, (float)n4);
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to draw icon in PDF", iOException);
        }
    }

    public static void drawIcon(PDDocument pDDocument, PDPageContentStream pDPageContentStream, BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            PDImageXObject pDImageXObject = PDImageXObject.createFromByteArray(pDDocument, byArray, "icon");
            pDPageContentStream.drawImage(pDImageXObject, (float)n, (float)n2, (float)n3, (float)n4);
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to draw icon in PDF", iOException);
        }
    }

    public static void drawIcon(PDPageContentStream pDPageContentStream, PDImageXObject pDImageXObject, int n, int n2, int n3, int n4) {
        try {
            if (pDImageXObject != null) {
                pDPageContentStream.drawImage(pDImageXObject, (float)n, (float)n2, (float)n3, (float)n4);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to draw icon in PDF", iOException);
        }
    }

    public static void drawEmptyRatingCircle(PDPageContentStream pDPageContentStream, int n, int n2, int n3, String string) throws IOException {
        if (string != null) {
            switch (string) {
                case "A": {
                    pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
                    break;
                }
                case "B": {
                    pDPageContentStream.setNonStrokingColor(0.71484375f, 0.8203125f, 0.2734375f);
                    break;
                }
                case "C": {
                    pDPageContentStream.setNonStrokingColor(0.890625f, 0.7421875f, 0.2578125f);
                    break;
                }
                case "D": {
                    pDPageContentStream.setNonStrokingColor(0.875f, 0.5078125f, 0.2265625f);
                    break;
                }
                case "E": {
                    pDPageContentStream.setNonStrokingColor(0.859375f, 0.1875f, 0.16796875f);
                }
            }
            pDPageContentStream.moveTo((float)n - (float)n3, n2);
            pDPageContentStream.curveTo((float)n - (float)n3, (float)n2 + 0.5522848f * (float)n3, (float)n - 0.5522848f * (float)n3, (float)n2 + (float)n3, n, (float)n2 + (float)n3);
            pDPageContentStream.curveTo((float)n + 0.5522848f * (float)n3, (float)n2 + (float)n3, (float)n + (float)n3, (float)n2 + 0.5522848f * (float)n3, (float)n + (float)n3, n2);
            pDPageContentStream.curveTo((float)n + (float)n3, (float)n2 - 0.5522848f * (float)n3, (float)n + 0.5522848f * (float)n3, (float)n2 - (float)n3, n, (float)n2 - (float)n3);
            pDPageContentStream.curveTo((float)n - 0.5522848f * (float)n3, (float)n2 - (float)n3, (float)n - (float)n3, (float)n2 - 0.5522848f * (float)n3, (float)n - (float)n3, n2);
            pDPageContentStream.fill();
            pDPageContentStream.setNonStrokingColor(Color.BLACK);
        }
    }

    public static void drawSizeRatingCircle(PDPageContentStream pDPageContentStream, int n, int n2, int n3) throws IOException {
        pDPageContentStream.setNonStrokingColor(0.30859375f, 0.625f, 0.82421875f);
        pDPageContentStream.moveTo((float)n - (float)n3, n2);
        pDPageContentStream.curveTo((float)n - (float)n3, (float)n2 + 0.5522848f * (float)n3, (float)n - 0.5522848f * (float)n3, (float)n2 + (float)n3, n, (float)n2 + (float)n3);
        pDPageContentStream.curveTo((float)n + 0.5522848f * (float)n3, (float)n2 + (float)n3, (float)n + (float)n3, (float)n2 + 0.5522848f * (float)n3, (float)n + (float)n3, n2);
        pDPageContentStream.curveTo((float)n + (float)n3, (float)n2 - 0.5522848f * (float)n3, (float)n + 0.5522848f * (float)n3, (float)n2 - (float)n3, n, (float)n2 - (float)n3);
        pDPageContentStream.curveTo((float)n - 0.5522848f * (float)n3, (float)n2 - (float)n3, (float)n - (float)n3, (float)n2 - 0.5522848f * (float)n3, (float)n - (float)n3, n2);
        pDPageContentStream.fill();
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }

    private static int setDuplicatedRatingColor(PDPageContentStream pDPageContentStream, Double d2) throws IOException {
        if (d2 < 3.0) {
            pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
            return 0;
        }
        if (d2 >= 3.0 && d2 < 5.0) {
            pDPageContentStream.setNonStrokingColor(0.71484375f, 0.8203125f, 0.2734375f);
            return 4;
        }
        if (d2 >= 5.0 && d2 < 10.0) {
            pDPageContentStream.setNonStrokingColor(0.890625f, 0.7421875f, 0.2578125f);
            return 8;
        }
        if (d2 >= 10.0 && d2 < 20.0) {
            pDPageContentStream.setNonStrokingColor(0.875f, 0.5078125f, 0.2265625f);
            return 12;
        }
        if (d2 >= 20.0) {
            pDPageContentStream.setNonStrokingColor(0.859375f, 0.1875f, 0.16796875f);
            return 16;
        }
        return 0;
    }

    private static void drawCircle(PDPageContentStream pDPageContentStream, int n, int n2, int n3) throws IOException {
        pDPageContentStream.moveTo((float)n - (float)n3, n2);
        pDPageContentStream.curveTo((float)n - (float)n3, (float)n2 + 0.5522848f * (float)n3, (float)n - 0.5522848f * (float)n3, (float)n2 + (float)n3, n, (float)n2 + (float)n3);
        pDPageContentStream.curveTo((float)n + 0.5522848f * (float)n3, (float)n2 + (float)n3, (float)n + (float)n3, (float)n2 + 0.5522848f * (float)n3, (float)n + (float)n3, n2);
        pDPageContentStream.curveTo((float)n + (float)n3, (float)n2 - 0.5522848f * (float)n3, (float)n + 0.5522848f * (float)n3, (float)n2 - (float)n3, n, (float)n2 - (float)n3);
        pDPageContentStream.curveTo((float)n - 0.5522848f * (float)n3, (float)n2 - (float)n3, (float)n - (float)n3, (float)n2 - 0.5522848f * (float)n3, (float)n - (float)n3, n2);
        pDPageContentStream.fill();
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }

    public static void drawRectangle(PDPageContentStream pDPageContentStream, int n, int n2, int n3, int n4, Color color) throws IOException {
        pDPageContentStream.setNonStrokingColor(color);
        pDPageContentStream.addRect(n, n2, n3, n4);
        pDPageContentStream.fill();
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }

    public static void drawDuplicatedRatingCircle(PDPageContentStream pDPageContentStream, int n, int n2, int n3, Double d2) throws IOException {
        PdfUtils.setDuplicatedRatingColor(pDPageContentStream, d2);
        PdfUtils.drawCircle(pDPageContentStream, n, n2, n3);
        pDPageContentStream.setNonStrokingColor(Color.WHITE);
        PdfUtils.drawCircle(pDPageContentStream, n, n2, n3 - 4);
        int n4 = PdfUtils.setDuplicatedRatingColor(pDPageContentStream, d2);
        PdfUtils.drawCircle(pDPageContentStream, n, n2, n4);
    }

    public static void drawRatingCircle(PDPageContentStream pDPageContentStream, int n, int n2, int n3, String string, PDFont pDFont) throws IOException {
        if (string != null) {
            int n4 = n3 * 5 / 4;
            PdfUtils.drawEmptyRatingCircle(pDPageContentStream, n, n2, n3, string);
            pDPageContentStream.setFont(pDFont, n4);
            pDPageContentStream.setNonStrokingColor(Color.WHITE);
            PdfUtils.drawCenterText(pDPageContentStream, pDFont, n4, string, n, n2 + n4);
            pDPageContentStream.setNonStrokingColor(Color.BLACK);
        }
    }

    public static void drawCoverage(PDPageContentStream pDPageContentStream, int n, int n2, int n3, int n4, Double d2) throws IOException {
        pDPageContentStream.setNonStrokingColor(0.859375f, 0.1875f, 0.16796875f);
        PdfUtils.drawCircle(pDPageContentStream, n, n2, n3);
        pDPageContentStream.setNonStrokingColor(Color.WHITE);
        double d3 = 360.0 * d2 / 100.0;
        pDPageContentStream.transform(Matrix.getTranslateInstance(n, n2));
        int n5 = Math.floorDiv((int)d3, 90);
        for (int i = 0; i < n5; ++i) {
            PdfUtils.drawSlice(pDPageContentStream, n3, 95.0 - (double)i * 90.0, (double)(-i) * 90.0);
        }
        if (d3 > 0.0) {
            PdfUtils.drawSlice(pDPageContentStream, n3, 95.0 - (double)n5 * 90.0, 90.0 - (double)n5 * 90.0 - (d3 - (double)(n5 * 90)));
        }
        pDPageContentStream.fill();
        pDPageContentStream.transform(Matrix.getTranslateInstance(0.0f - (float)n, 0.0f - (float)n2));
        pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
        double d4 = 360.0 * (d2 - 1.0) / 100.0;
        pDPageContentStream.transform(Matrix.getTranslateInstance(n, n2));
        n5 = Math.floorDiv((int)d4, 90);
        for (int i = 0; i < n5; ++i) {
            PdfUtils.drawSlice(pDPageContentStream, n3, 90.0 - (double)i * 90.0, (double)(-i) * 90.0);
        }
        if (d4 > 0.0) {
            PdfUtils.drawSlice(pDPageContentStream, n3, 90.0 - (double)n5 * 90.0, 90.0 - (double)n5 * 90.0 - (d4 - (double)(n5 * 90)));
        }
        pDPageContentStream.fill();
        pDPageContentStream.transform(Matrix.getTranslateInstance(0.0f - (float)n, 0.0f - (float)n2));
        pDPageContentStream.setNonStrokingColor(Color.WHITE);
        PdfUtils.drawCircle(pDPageContentStream, n, n2, n4);
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }

    private static void drawSlice(PDPageContentStream pDPageContentStream, double d2, double d3, double d4) throws IOException {
        pDPageContentStream.moveTo(0.0f, 0.0f);
        List<Float> list = PdfUtils.createSmallArc(d2, Math.toRadians(d3), Math.toRadians(d4));
        pDPageContentStream.lineTo(list.get(0).floatValue(), list.get(1).floatValue());
        pDPageContentStream.curveTo(list.get(2).floatValue(), list.get(3).floatValue(), list.get(4).floatValue(), list.get(5).floatValue(), list.get(6).floatValue(), list.get(7).floatValue());
        pDPageContentStream.closePath();
    }

    private static List<Float> createSmallArc(double d2, double d3, double d4) {
        double d5 = (d4 - d3) / 2.0;
        double d6 = d2 * Math.cos(d5);
        double d7 = d2 * Math.sin(d5);
        double d8 = d6;
        double d9 = -d7;
        double d10 = d8 * d8 + d9 * d9;
        double d11 = d10 + d8 * d6 + d9 * d7;
        double d12 = 1.3333333333333333 * (Math.sqrt(2.0 * d10 * d11) - d11) / (d8 * d7 - d9 * d6);
        double d13 = d8 - d12 * d9;
        double d14 = d9 + d12 * d8;
        double d15 = d13;
        double d16 = -d14;
        double d17 = d5 + d3;
        double d18 = Math.cos(d17);
        double d19 = Math.sin(d17);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        arrayList.add(Float.valueOf((float)(d2 * Math.cos(d3))));
        arrayList.add(Float.valueOf((float)(d2 * Math.sin(d3))));
        arrayList.add(Float.valueOf((float)(d13 * d18 - d14 * d19)));
        arrayList.add(Float.valueOf((float)(d13 * d19 + d14 * d18)));
        arrayList.add(Float.valueOf((float)(d15 * d18 - d16 * d19)));
        arrayList.add(Float.valueOf((float)(d15 * d19 + d16 * d18)));
        arrayList.add(Float.valueOf((float)(d2 * Math.cos(d4))));
        arrayList.add(Float.valueOf((float)(d2 * Math.sin(d4))));
        return arrayList;
    }

    public static void drawNullRatingCircle(PDPageContentStream pDPageContentStream, int n, int n2, int n3, PDFont pDFont) throws IOException {
        int n4 = n3 * 5 / 4;
        pDPageContentStream.setFont(pDFont, n4);
        pDPageContentStream.setNonStrokingColor(Color.WHITE);
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, n4, "-", n, n2 + n4);
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawText(PDPageContentStream pDPageContentStream, PDFont pDFont, int n, String string, int n2, int n3) {
        if (string != null) {
            try {
                string = string.replace('\n', '.');
                pDPageContentStream.setFont(pDFont, n);
                pDPageContentStream.beginText();
                pDPageContentStream.newLineAtOffset(n2, n3);
                pDPageContentStream.showText(string);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to draw text in pdf: {}", (Object)string);
                LOGGER.error("Exception: {}", (Object)iOException.getMessage(), (Object)iOException);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Unable to draw text due to font support: {}", (Object)throwable.getMessage());
            }
            finally {
                try {
                    pDPageContentStream.endText();
                }
                catch (IOException iOException) {
                    LOGGER.error("Unable to end text in content stream! PDF generation may be wrong!", iOException);
                }
            }
        }
    }

    public static void drawTextBlock(PDPageContentStream pDPageContentStream, PDFont pDFont, int n, String string, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = n + 2;
        int n7 = (string = string.replace('\n', '.')).indexOf(". ");
        if (n7 != -1) {
            string = string.substring(0, n7);
        } else {
            n7 = string.indexOf("Noncompliant");
            if (n7 != -1) {
                string = string.substring(0, n7);
            }
        }
        if (string != null) {
            for (int i = 0; i < n4; ++i) {
                if (string.length() <= n5) {
                    PdfUtils.drawText(pDPageContentStream, pDFont, n, string + ".", n2, n3 - i * n6);
                    break;
                }
                int n8 = string.indexOf(32, n5 - 20);
                String string2 = string.substring(0, n8).trim();
                string = string.substring(n8).trim();
                PdfUtils.drawText(pDPageContentStream, pDFont, n, string2, n2, n3 - i * n6);
            }
        }
    }

    public static void writeVersionLabel(PDPageContentStream pDPageContentStream, PDFont pDFont, String string, int n, int n2) throws IOException {
        pDPageContentStream.setNonStrokingColor(Color.decode(LABELS_COLOR));
        PdfUtils.drawText(pDPageContentStream, pDFont, 9, string, n, n2);
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }

    public static void writeProjectVersionInfo(SonarQubeProject sonarQubeProject, Fonts fonts, String string, PDPageContentStream pDPageContentStream, int n, int n2, boolean bl) throws IOException {
        PdfUtils.writeVersionLabel(pDPageContentStream, fonts.getBoldFont(), string, n, n2 + 14);
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, ParamUtils.getProjectVersion(sonarQubeProject, bl), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCenterText(PDPageContentStream pDPageContentStream, PDFont pDFont, int n, String string, int n2, int n3) {
        if (string != null) {
            try {
                float f = pDFont.getStringWidth(string) / 1000.0f * (float)n;
                float f2 = pDFont.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)n;
                float f3 = (float)n2 - f / 2.0f;
                float f4 = (float)n3 - f2;
                pDPageContentStream.beginText();
                pDPageContentStream.setFont(pDFont, n);
                pDPageContentStream.newLineAtOffset(f3, f4);
                pDPageContentStream.showText(string);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to draw text in pdf: {}", (Object)string);
                LOGGER.error("Exception: {}", (Object)iOException.getMessage(), (Object)iOException);
            }
            finally {
                try {
                    pDPageContentStream.endText();
                }
                catch (IOException iOException) {
                    LOGGER.error("Unable to end text in content stream! PDF generation may be wrong!", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRightAlignedText(PDPageContentStream pDPageContentStream, PDFont pDFont, int n, String string, int n2, int n3) {
        if (string != null) {
            try {
                float f = pDFont.getStringWidth(string) / 1000.0f * (float)n;
                float f2 = pDFont.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)n;
                float f3 = (float)n2 - f;
                float f4 = (float)n3 - f2;
                pDPageContentStream.beginText();
                pDPageContentStream.setFont(pDFont, n);
                pDPageContentStream.newLineAtOffset(f3, f4);
                pDPageContentStream.showText(string);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to draw text in pdf: {}", (Object)string);
                LOGGER.error("Exception: {}", (Object)iOException.getMessage(), (Object)iOException);
            }
            finally {
                try {
                    pDPageContentStream.endText();
                }
                catch (IOException iOException) {
                    LOGGER.error("Unable to end text in content stream! PDF generation may be wrong!", iOException);
                }
            }
        }
    }

    public static void drawSeverityRectangle(PDPageContentStream pDPageContentStream, int n, int n2, int n3, String string) throws IOException {
        switch (string) {
            case "INFO": {
                pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
                break;
            }
            case "MINOR": {
                pDPageContentStream.setNonStrokingColor(0.71484375f, 0.8203125f, 0.2734375f);
                break;
            }
            case "MAJOR": {
                pDPageContentStream.setNonStrokingColor(0.890625f, 0.7421875f, 0.2578125f);
                break;
            }
            case "CRITICAL": {
                pDPageContentStream.setNonStrokingColor(0.875f, 0.5078125f, 0.2265625f);
                break;
            }
            case "BLOCKER": {
                pDPageContentStream.setNonStrokingColor(0.859375f, 0.1875f, 0.16796875f);
            }
        }
        pDPageContentStream.addRect(n, n2, n3, n3);
        pDPageContentStream.fill();
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
    }
}

