/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.common;

import com.bitegarden.sonar.plugins.common.EnabledStatusWebService;
import com.bitegarden.sonar.plugins.common.SonarPlugin;
import com.bitegarden.sonar.plugins.common.ctx.PluginContext;
import com.bitegarden.sonar.plugins.common.exception.PluginFatalException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;

public abstract class DisableablePlugin
extends SonarPlugin {
    public static final String CTXKEY_ENABLED_PROP_KEY = "DisableablePlugin.enabledPropKey";

    public DisableablePlugin(String string) {
        String string2 = string;
        if (StringUtils.isBlank(string2)) {
            throw new PluginFatalException("You have to define the enabled property key when using a DisableablePlugin");
        }
        DisableablePlugin.setEnabledPropKey(string);
    }

    protected static final boolean isEnabled(Settings settings) {
        String string = settings.getString(DisableablePlugin.getEnabledPropKey());
        return DisableablePlugin.isEnabled(string);
    }

    private static void setEnabledPropKey(String string) {
        PluginContext.get().setProperty(CTXKEY_ENABLED_PROP_KEY, string);
    }

    public static final String getEnabledPropKey() {
        String string = (String)PluginContext.get().getProperty(CTXKEY_ENABLED_PROP_KEY);
        if (StringUtils.isBlank(string)) {
            throw new PluginFatalException("Make sure you are using a DisableablePlugin and passing a enabled property key to the constructor. If you are testing, try to simulate Sonar behaviour calling \nPluginContext.get().setProperty(DisableablePlugin.CTXKEY_ENABLED_PROP_KEY, \"yourpluginkey.enabled\")");
        }
        return string;
    }

    @Override
    public final List getSonarPluginExtensions() {
        ArrayList<Class<EnabledStatusWebService>> arrayList = new ArrayList<Class<EnabledStatusWebService>>();
        arrayList.add(EnabledStatusWebService.class);
        arrayList.addAll(this.getDisableablePluginExtensions());
        return arrayList;
    }

    public abstract List getDisableablePluginExtensions();

    public static boolean isEnabled(String string) {
        boolean bl = false;
        if (StringUtils.isBlank(string) || "true".equalsIgnoreCase(string)) {
            bl = true;
        }
        return bl;
    }
}

