/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class WorkDuration {
    private static final long serialVersionUID = -6476735363943518708L;
    private static final String DAY = "d";
    private static final String HOUR = "h";
    private static final String MINUTE = "min";
    private static final String MINUTES_FORMAT = "%smin";
    private static final String HOURS_FORMAT = "%sh";
    private static final String DAYS_FORMAT = "%sd";
    private static final int HOURS_IN_DAY = 8;
    private static final short MINUTES_IN_ONE_HOUR = 60;
    private final long durationInMinutes;

    private WorkDuration(long l) {
        this.durationInMinutes = l;
    }

    private WorkDuration(int n, int n2, int n3, int n4) {
        this((long)n * (long)n4 * 60L + (long)(n2 * 60) + (long)n3);
    }

    public static WorkDuration create(long l) {
        return new WorkDuration(l);
    }

    public static WorkDuration decode(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = StringUtils.deleteWhitespace(string);
        Pattern pattern = Pattern.compile("\\s*+(?:(\\d++)\\s*+d)?+\\s*+(?:(\\d++)\\s*+h)?+\\s*+(?:(\\d++)\\s*+min)?+\\s*+");
        Matcher matcher = pattern.matcher(string);
        try {
            if (matcher.find()) {
                String string3;
                String string4;
                String string5 = matcher.group(1);
                if (string5 != null) {
                    n2 = Integer.parseInt(string5);
                    string2 = string2.replace(string5 + DAY, "");
                }
                if ((string4 = matcher.group(2)) != null) {
                    n3 = Integer.parseInt(string4);
                    string2 = string2.replace(string4 + HOUR, "");
                }
                if ((string3 = matcher.group(3)) != null) {
                    n4 = Integer.parseInt(string3);
                    string2 = string2.replace(string3 + MINUTE, "");
                }
                if (string2.isEmpty()) {
                    return new WorkDuration(n2, n3, n4, n);
                }
            }
            throw WorkDuration.invalid(string, null);
        }
        catch (NumberFormatException numberFormatException) {
            throw WorkDuration.invalid(string, numberFormatException);
        }
    }

    public String encode(int n) {
        int n2 = Double.valueOf((double)this.durationInMinutes / (double)n / 60.0).intValue();
        Long l = this.durationInMinutes - (long)(n2 * n * 60);
        int n3 = Double.valueOf(l.doubleValue() / 60.0).intValue();
        l = l - (long)(n3 * 60);
        int n4 = l.intValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append(n2);
            stringBuilder.append(DAY);
        }
        if (n3 > 0) {
            stringBuilder.append(n3);
            stringBuilder.append(HOUR);
        }
        if (n4 > 0) {
            stringBuilder.append(n4);
            stringBuilder.append(MINUTE);
        }
        return stringBuilder.length() == 0 ? "0min" : stringBuilder.toString();
    }

    public long toMinutes() {
        return this.durationInMinutes;
    }

    public boolean isGreaterThan(WorkDuration workDuration) {
        return this.toMinutes() > workDuration.toMinutes();
    }

    public WorkDuration add(WorkDuration workDuration) {
        return WorkDuration.create(this.durationInMinutes + workDuration.durationInMinutes);
    }

    public WorkDuration subtract(WorkDuration workDuration) {
        return WorkDuration.create(this.durationInMinutes - workDuration.durationInMinutes);
    }

    public WorkDuration multiply(int n) {
        return WorkDuration.create(this.durationInMinutes * (long)n);
    }

    private static IllegalArgumentException invalid(String string, @Nullable Exception exception) {
        throw new IllegalArgumentException(String.format("Duration '%s' is invalid, it should use the following sample format : 2d 10h 15min", string), exception);
    }

    public static String format(WorkDuration workDuration) {
        Long l = workDuration.toMinutes();
        if (l == 0L) {
            return "0";
        }
        boolean bl = l < 0L;
        Long l2 = Math.abs(l);
        int n = Double.valueOf((double)l2.longValue() / 8.0 / 60.0).intValue();
        Long l3 = l2 - (long)(n * 8 * 60);
        int n2 = Double.valueOf(l3.doubleValue() / 60.0).intValue();
        l3 = l3 - (long)(n2 * 60);
        int n3 = l3.intValue();
        return WorkDuration.format(n, n2, n3, bl);
    }

    private static String format(int n, int n2, int n3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            stringBuilder.append(String.format(DAYS_FORMAT, bl ? -1 * n : n));
        }
        if (WorkDuration.displayHours(n, n2)) {
            WorkDuration.addSpaceIfNeeded(stringBuilder);
            stringBuilder.append(String.format(HOURS_FORMAT, bl && stringBuilder.length() == 0 ? -1 * n2 : n2));
        }
        if (WorkDuration.displayMinutes(n, n2, n3)) {
            WorkDuration.addSpaceIfNeeded(stringBuilder);
            stringBuilder.append(String.format(MINUTES_FORMAT, bl && stringBuilder.length() == 0 ? -1 * n3 : n3));
        }
        return stringBuilder.toString();
    }

    private static boolean displayHours(int n, int n2) {
        return n2 > 0 && n < 10;
    }

    private static boolean displayMinutes(int n, int n2, int n3) {
        return n3 > 0 && n2 < 10 && n == 0;
    }

    private static void addSpaceIfNeeded(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WorkDuration workDuration = (WorkDuration)object;
        return this.durationInMinutes == workDuration.durationInMinutes;
    }

    public int hashCode() {
        return (int)(this.durationInMinutes ^ this.durationInMinutes >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

