/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.protobuf.GeneratedMessageV3;
import es.sonarqube.api.SonarQubeIssueBreakdown;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeHotspotManager;
import es.sonarqube.managers.SonarQubeProjectManager;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.managers.SonarQubeURLManager;
import es.sonarqube.utils.FormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.issues.SearchRequest;

public class SonarQubeIssueManager {
    public static final String MAJOR = "MAJOR";
    public static final String MINOR = "MINOR";
    public static final String INFO = "INFO";
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeIssueManager.class);
    private static final String BLOCKER = "BLOCKER";
    private static final String CRITICAL = "CRITICAL";
    private static final String BUG = "BUG";
    private static final String VULNERABILITY = "VULNERABILITY";
    private static final String CODE_SMELL = "CODE_SMELL";
    private static final String SECURITY_HOTSPOT = "SECURITY_HOTSPOT";
    private final WsClient wsClient;
    private final Locale userLocale;
    private static final String ERROR_GETTING_ISSUE_FROM_SEVERITY = "Error getting issues from projects (%s) from severity (%s), error -> %s";
    private static final String RULE_RETRIEVED = "Rule retrieved: {}";
    private static final String ISSUES_FOR_RULE = "Number of issues for rule: {}";
    private static final String RULE_CATEGORIZED_AS_HOTSPOT = "Rule is categorized as HOTSPOT";

    public SonarQubeIssueManager(WsClient wsClient, Locale locale) {
        this.wsClient = wsClient;
        this.userLocale = locale;
    }

    public SonarQubeIssueManager(String string, String string2, Locale locale) {
        this.userLocale = locale;
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static SonarQubeIssueBreakdown getIssueBreakdown(WsClient wsClient, List<String> list, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getIssueBreakdown(list, string);
    }

    protected static List<Issues.Issue> getIssuesForRule(WsClient wsClient, String string, String string2, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getIssuesForRule(string, string2);
    }

    protected static Map<String, Long> getBlockerRules(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getBlockerRules(list);
    }

    protected static Map<String, Long> getCriticalRules(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getCriticalRules(list);
    }

    protected static List<Issues.Issue> searchIssuesByAuthor(WsClient wsClient, List<String> list, List<String> list2, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).searchIssuesByAuthor(list, list2, string);
    }

    public Map<String, Long> getBlockerRules(List<String> list) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, BLOCKER, "");
    }

    public Map<String, Long> getBlockerRules(String string, String string2) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, BLOCKER, string2);
    }

    public Map<String, Long> getCriticalRules(List<String> list) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, CRITICAL, "");
    }

    public Map<String, Long> getCriticalRules(String string, String string2) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, CRITICAL, string2);
    }

    public Map<String, Long> getIssuesForResolution(List<String> list, String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList("rules"));
        searchRequest.setResolutions(Collections.singletonList(string));
        searchRequest.setProjects(list);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForResolution(List<String> list, String string) {
        return this.getIssuesForResolution(list, string, null);
    }

    public Map<String, Long> getIssuesForResolution(String string, String string2) {
        return this.getIssuesForResolution(Collections.singletonList(string), string2, null);
    }

    public Map<String, Long> getIssuesForResolution(String string, String string2, String string3) {
        return this.getIssuesForResolution(Collections.singletonList(string), string2, string3);
    }

    public Map<String, Long> getIssuesByRule(List<String> list, String string) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList("rules"));
        searchRequest.setResolved("false");
        searchRequest.setProjects(list);
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesByRule(List<String> list) {
        return this.getIssuesByRule(list, null);
    }

    public Map<String, Long> getIssuesByRule(String string) {
        return this.getIssuesByRule(Collections.singletonList(string), null);
    }

    public Map<String, Long> getIssuesByRule(String string, String string2) {
        return this.getIssuesByRule(Collections.singletonList(string), string2);
    }

    public Map<String, Long> getIssuesTypeByRule(List<String> list, String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList("rules"));
        searchRequest.setResolved("false");
        searchRequest.setProjects(list);
        searchRequest.setTypes(Arrays.asList(string));
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverity(String string, String string2) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, string2, null);
    }

    public Map<String, Long> getIssuesForSeverity(String string, String string2, String string3) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, string2, string3);
    }

    public Map<String, Long> getIssuesForType(List<String> list, List<String> list2, String string, String string2) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForTypeByAuthor(list, list2, string2);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> {
                if (facetValue.getVal().equals(string)) {
                    hashMap.put(facetValue.getVal(), facetValue.getCount());
                }
            }));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting issues from projects (%s) from type (%s), error -> %s", list, string, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Error getting issues from projects (%s) from type (%s), error -> %s", list, string, exception));
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverity(List<String> list, List<String> list2, String string, String string2) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForRules(list, list2, string, "", string2);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string, exception));
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverity(String string, String string2, String string3, String string4, String string5) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), string2, string3, string4, string5);
    }

    public Map<String, Long> getIssuesForSeverity(List<String> list, String string, String string2, String string3, String string4) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForRules(list, string, "", string2, string3, string4);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string, exception));
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverityByAuthors(List<String> list, String string, String string2, String string3, String string4) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForAuthors(list, string, string2, string3, string4);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.error("Error HTTP getting issues from projects ({}) from severity ({}), error -> {}", list, string, httpException.getMessage(), httpException);
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error("Error getting issues from projects ({}) from severity ({}), error -> {}", list, string, exception.getMessage(), exception);
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverityByProjects(List<String> list, String string, String string2, String string3, String string4) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForProjects(list, string, string2, string3, string4);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.error("Error HTTP getting issues from projects ({}) from severity ({}), error -> {}", list, string, httpException.getMessage(), httpException);
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error("Error getting issues from projects ({}) from severity ({}), error -> {}", list, string, exception.getMessage(), exception);
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public List<Issues.Issue> getIssuesForRule(String string, String string2) throws SonarQubeException {
        try {
            return this.searchIssues(Collections.singletonList(string), "", string2);
        }
        catch (HttpException httpException) {
            LOGGER.error(String.format("Error getting issues from project (%s) with sonar rule (%s), error -> %s", string, string2, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Error getting issues from project (%s) with sonar rule (%s), error -> %s", string, string2, exception));
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
    }

    public List<Issues.Issue> getIssuesForRule(String string, String string2, String string3) throws SonarQubeException {
        try {
            return this.searchIssues(Collections.singletonList(string), "", string2, string3);
        }
        catch (HttpException httpException) {
            LOGGER.error(String.format("Error getting issues from project (%s) with sonar rule (%s), error -> %s", string, string2, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Error getting issues from project (%s) with sonar rule (%s), error -> %s", string, string2, exception));
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
    }

    public List<Issues.Issue> getIssuesForRule(String string, String string2, String string3, String string4) throws SonarQubeException {
        try {
            return this.searchIssues(Collections.singletonList(string), string2, string3, string4);
        }
        catch (HttpException httpException) {
            LOGGER.error(String.format("Error getting issues from project (%s) with sonar rule (%s), error -> %s", string, string3, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Error getting issues from project (%s) with sonar rule (%s), error -> %s", string, string3, exception));
            throw new SonarQubeException(String.format("Error getting issues: %s", exception.getMessage()));
        }
    }

    public SonarQubeIssueBreakdown getIssueBreakdown(String string) throws SonarQubeException {
        return this.getIssueBreakdown(Collections.singletonList(string), null);
    }

    public SonarQubeIssueBreakdown getIssueBreakdown(String string, String string2) throws SonarQubeException {
        return this.getIssueBreakdown(Collections.singletonList(string), string2);
    }

    public SonarQubeIssueBreakdown getIssueBreakdown(List<String> list) throws SonarQubeException {
        return this.getIssueBreakdown(list, null);
    }

    private SonarQubeIssueBreakdown getIssueBreakdown(List<String> list, String string) throws SonarQubeException {
        String string2;
        Object object;
        Serializable serializable;
        String string3 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
        SonarQubeIssueBreakdown sonarQubeIssueBreakdown = new SonarQubeIssueBreakdown();
        int n = Integer.parseInt(SonarQubeServerManager.getSonarQubeVersion(this.wsClient).substring(0, 1));
        Map<String, Long> map = this.getBlockerRules(list, string);
        Map<String, Long> map2 = this.getCriticalRules(list, string);
        Map<String, Long> map3 = this.getMajorRules(list, string);
        Map<String, Long> map4 = this.getMinorRules(list, string);
        Map<String, Long> map5 = this.getInfoRules(list, string);
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        SonarQubeHotspotManager sonarQubeHotspotManager = new SonarQubeHotspotManager(this.wsClient);
        for (String iterator : list) {
            Map<String, Long> map6 = sonarQubeHotspotManager.getAllSecurityHotspots(iterator, string);
            for (Map.Entry<String, Long> entry : map6.entrySet()) {
                serializable = Long.valueOf(hashMap.getOrDefault(entry.getKey(), Long.valueOf(0L)) + entry.getValue());
                hashMap.put(entry.getKey(), serializable);
            }
        }
        List<Object> list2 = n > 6 ? Collections.emptyList() : SonarQubeProjectManager.getUuids(this.wsClient, list, this.userLocale);
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            object = entry.getKey();
            Long l = entry.getValue();
            serializable = SonarQubeRuleManager.getRule(this.wsClient, (String)object);
            LOGGER.debug(RULE_RETRIEVED, object);
            string2 = FormatUtils.getNumber(this.userLocale).format(l);
            LOGGER.debug(ISSUES_FOR_RULE, (Object)string2);
            switch (((Rules.Rule)serializable).getType().name()) {
                case "BUG": {
                    LOGGER.debug("Rule is categorized as BUG");
                    sonarQubeIssueBreakdown.getBlockerBugs().put((String)object, l);
                    break;
                }
                case "VULNERABILITY": {
                    LOGGER.debug("Rule is categorized as VULNERABILITY");
                    sonarQubeIssueBreakdown.getBlockerVulnerabilities().put((String)object, l);
                    break;
                }
                case "SECURITY_HOTSPOT": {
                    LOGGER.debug(RULE_CATEGORIZED_AS_HOTSPOT);
                    sonarQubeIssueBreakdown.getBlockerHotspots().put((String)object, l);
                    break;
                }
                default: {
                    LOGGER.debug("Rule is categorized as CODE SMELL");
                    sonarQubeIssueBreakdown.getBlockerCodeSmells().put((String)object, l);
                }
            }
            sonarQubeIssueBreakdown.getRulesObjects().put((String)object, (Rules.Rule)serializable);
            sonarQubeIssueBreakdown.getRulesValues().put((String)object, string2);
            sonarQubeIssueBreakdown.getRulesUrls().put((String)object, this.getUrl(list, string, string3, (List<String>)list2, (String)object, (Rules.Rule)serializable));
        }
        for (Map.Entry<String, Long> entry : map2.entrySet()) {
            object = entry.getKey();
            Long l = entry.getValue();
            serializable = SonarQubeRuleManager.getRule(this.wsClient, (String)object);
            LOGGER.debug(RULE_RETRIEVED, object);
            string2 = FormatUtils.getNumber(this.userLocale).format(l);
            LOGGER.debug(ISSUES_FOR_RULE, (Object)string2);
            switch (((Rules.Rule)serializable).getType().name()) {
                case "BUG": {
                    sonarQubeIssueBreakdown.getCriticalBugs().put((String)object, l);
                    break;
                }
                case "VULNERABILITY": {
                    sonarQubeIssueBreakdown.getCriticalVulnerabilities().put((String)object, l);
                    break;
                }
                case "SECURITY_HOTSPOT": {
                    LOGGER.debug(RULE_CATEGORIZED_AS_HOTSPOT);
                    sonarQubeIssueBreakdown.getCriticalHotspots().put((String)object, l);
                    break;
                }
                default: {
                    sonarQubeIssueBreakdown.getCriticalCodeSmells().put((String)object, l);
                }
            }
            sonarQubeIssueBreakdown.getRulesObjects().put((String)object, (Rules.Rule)serializable);
            sonarQubeIssueBreakdown.getRulesValues().put((String)object, string2);
            sonarQubeIssueBreakdown.getRulesUrls().put((String)object, this.getUrl(list, string, string3, (List<String>)list2, (String)object, (Rules.Rule)serializable));
        }
        for (Map.Entry<String, Long> entry : map3.entrySet()) {
            object = entry.getKey();
            Long l = entry.getValue();
            serializable = SonarQubeRuleManager.getRule(this.wsClient, (String)object);
            LOGGER.debug(RULE_RETRIEVED, object);
            string2 = FormatUtils.getNumber(this.userLocale).format(l);
            LOGGER.debug(ISSUES_FOR_RULE, (Object)string2);
            switch (((Rules.Rule)serializable).getType().name()) {
                case "BUG": {
                    sonarQubeIssueBreakdown.getMajorBugs().put((String)object, l);
                    break;
                }
                case "VULNERABILITY": {
                    sonarQubeIssueBreakdown.getMajorVulnerabilities().put((String)object, l);
                    break;
                }
                case "SECURITY_HOTSPOT": {
                    LOGGER.debug(RULE_CATEGORIZED_AS_HOTSPOT);
                    sonarQubeIssueBreakdown.getMajorHotspots().put((String)object, l);
                    break;
                }
                default: {
                    sonarQubeIssueBreakdown.getMajorCodeSmells().put((String)object, l);
                }
            }
            sonarQubeIssueBreakdown.getRulesObjects().put((String)object, (Rules.Rule)serializable);
            sonarQubeIssueBreakdown.getRulesValues().put((String)object, string2);
            sonarQubeIssueBreakdown.getRulesUrls().put((String)object, this.getUrl(list, string, string3, (List<String>)list2, (String)object, (Rules.Rule)serializable));
        }
        for (Map.Entry<String, Long> entry : map4.entrySet()) {
            object = entry.getKey();
            Long l = entry.getValue();
            serializable = SonarQubeRuleManager.getRule(this.wsClient, (String)object);
            LOGGER.debug(RULE_RETRIEVED, object);
            string2 = FormatUtils.getNumber(this.userLocale).format(l);
            LOGGER.debug(ISSUES_FOR_RULE, (Object)string2);
            switch (((Rules.Rule)serializable).getType().name()) {
                case "BUG": {
                    sonarQubeIssueBreakdown.getMinorBugs().put((String)object, l);
                    break;
                }
                case "VULNERABILITY": {
                    sonarQubeIssueBreakdown.getMinorVulnerabilities().put((String)object, l);
                    break;
                }
                case "SECURITY_HOTSPOT": {
                    LOGGER.debug(RULE_CATEGORIZED_AS_HOTSPOT);
                    sonarQubeIssueBreakdown.getMinorHotspots().put((String)object, l);
                    break;
                }
                default: {
                    sonarQubeIssueBreakdown.getMinorCodeSmells().put((String)object, l);
                }
            }
            sonarQubeIssueBreakdown.getRulesObjects().put((String)object, (Rules.Rule)serializable);
            sonarQubeIssueBreakdown.getRulesValues().put((String)object, string2);
            sonarQubeIssueBreakdown.getRulesUrls().put((String)object, this.getUrl(list, string, string3, (List<String>)list2, (String)object, (Rules.Rule)serializable));
        }
        for (Map.Entry<String, Long> entry : map5.entrySet()) {
            object = entry.getKey();
            Long l = entry.getValue();
            serializable = SonarQubeRuleManager.getRule(this.wsClient, (String)object);
            LOGGER.debug(RULE_RETRIEVED, object);
            string2 = FormatUtils.getNumber(this.userLocale).format(l);
            LOGGER.debug(ISSUES_FOR_RULE, (Object)string2);
            switch (((Rules.Rule)serializable).getType().name()) {
                case "BUG": {
                    sonarQubeIssueBreakdown.getInfoBugs().put((String)object, l);
                    break;
                }
                case "VULNERABILITY": {
                    sonarQubeIssueBreakdown.getInfoVulnerabilities().put((String)object, l);
                    break;
                }
                case "SECURITY_HOTSPOT": {
                    LOGGER.debug(RULE_CATEGORIZED_AS_HOTSPOT);
                    sonarQubeIssueBreakdown.getInfoHotspots().put((String)object, l);
                    break;
                }
                default: {
                    sonarQubeIssueBreakdown.getInfoCodeSmells().put((String)object, l);
                }
            }
            sonarQubeIssueBreakdown.getRulesObjects().put((String)object, (Rules.Rule)serializable);
            sonarQubeIssueBreakdown.getRulesValues().put((String)object, string2);
            sonarQubeIssueBreakdown.getRulesUrls().put((String)object, this.getUrl(list, string, string3, (List<String>)list2, (String)object, (Rules.Rule)serializable));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            Long l = (Long)entry.getValue();
            serializable = SonarQubeRuleManager.getRule(this.wsClient, (String)object);
            LOGGER.debug(RULE_RETRIEVED, object);
            string2 = FormatUtils.getNumber(this.userLocale).format(l);
            LOGGER.debug(ISSUES_FOR_RULE, (Object)string2);
            switch (((Rules.Rule)serializable).getSeverity()) {
                case "BLOCKER": {
                    sonarQubeIssueBreakdown.getBlockerHotspots().put((String)object, l);
                    break;
                }
                case "CRITICAL": {
                    sonarQubeIssueBreakdown.getCriticalHotspots().put((String)object, l);
                    break;
                }
                case "MAJOR": {
                    sonarQubeIssueBreakdown.getMajorHotspots().put((String)object, l);
                    break;
                }
                case "MINOR": {
                    sonarQubeIssueBreakdown.getMinorHotspots().put((String)object, l);
                    break;
                }
                case "INFO": {
                    sonarQubeIssueBreakdown.getInfoHotspots().put((String)object, l);
                    break;
                }
                default: {
                    LOGGER.warn("Rule without categorized severity");
                }
            }
            sonarQubeIssueBreakdown.getRulesObjects().put((String)object, (Rules.Rule)serializable);
            sonarQubeIssueBreakdown.getRulesValues().put((String)object, string2);
            if (list.size() == 1) {
                sonarQubeIssueBreakdown.getRulesUrls().put((String)object, SonarQubeURLManager.getHotSpotsUrl(this.wsClient.wsConnector().baseUrl(), list.get(0), string3, string));
                continue;
            }
            sonarQubeIssueBreakdown.getRulesUrls().put((String)object, SonarQubeURLManager.getIssuesMultiProjectUrl(this.wsClient.wsConnector().baseUrl(), list, (List<String>)list2, string3, (String)object));
        }
        sonarQubeIssueBreakdown.setBlockerBugs(this.sortByValue(sonarQubeIssueBreakdown.getBlockerBugs()));
        sonarQubeIssueBreakdown.setBlockerVulnerabilities(this.sortByValue(sonarQubeIssueBreakdown.getBlockerVulnerabilities()));
        sonarQubeIssueBreakdown.setBlockerCodeSmells(this.sortByValue(sonarQubeIssueBreakdown.getBlockerCodeSmells()));
        sonarQubeIssueBreakdown.setBlockerHotspots(this.sortByValue(sonarQubeIssueBreakdown.getBlockerHotspots()));
        sonarQubeIssueBreakdown.setCriticalBugs(this.sortByValue(sonarQubeIssueBreakdown.getCriticalBugs()));
        sonarQubeIssueBreakdown.setCriticalVulnerabilities(this.sortByValue(sonarQubeIssueBreakdown.getCriticalVulnerabilities()));
        sonarQubeIssueBreakdown.setCriticalCodeSmells(this.sortByValue(sonarQubeIssueBreakdown.getCriticalCodeSmells()));
        sonarQubeIssueBreakdown.setCriticalHotspots(this.sortByValue(sonarQubeIssueBreakdown.getCriticalHotspots()));
        sonarQubeIssueBreakdown.setMajorBugs(this.sortByValue(sonarQubeIssueBreakdown.getMajorBugs()));
        sonarQubeIssueBreakdown.setMajorVulnerabilities(this.sortByValue(sonarQubeIssueBreakdown.getMajorVulnerabilities()));
        sonarQubeIssueBreakdown.setMajorHotspots(this.sortByValue(sonarQubeIssueBreakdown.getMajorHotspots()));
        sonarQubeIssueBreakdown.setMajorCodeSmells(this.sortByValue(sonarQubeIssueBreakdown.getMajorCodeSmells()));
        sonarQubeIssueBreakdown.setMinorBugs(this.sortByValue(sonarQubeIssueBreakdown.getMinorBugs()));
        sonarQubeIssueBreakdown.setMinorVulnerabilities(this.sortByValue(sonarQubeIssueBreakdown.getMinorVulnerabilities()));
        sonarQubeIssueBreakdown.setMinorHotspots(this.sortByValue(sonarQubeIssueBreakdown.getMinorHotspots()));
        sonarQubeIssueBreakdown.setMinorCodeSmells(this.sortByValue(sonarQubeIssueBreakdown.getMinorCodeSmells()));
        sonarQubeIssueBreakdown.setInfoBugs(this.sortByValue(sonarQubeIssueBreakdown.getInfoBugs()));
        sonarQubeIssueBreakdown.setInfoVulnerabilities(this.sortByValue(sonarQubeIssueBreakdown.getInfoVulnerabilities()));
        sonarQubeIssueBreakdown.setInfoHotspots(this.sortByValue(sonarQubeIssueBreakdown.getInfoHotspots()));
        sonarQubeIssueBreakdown.setInfoCodeSmells(this.sortByValue(sonarQubeIssueBreakdown.getInfoCodeSmells()));
        return sonarQubeIssueBreakdown;
    }

    private String getUrl(List<String> list, String string, String string2, List<String> list2, String string3, Rules.Rule rule) {
        if (list.size() == 1) {
            if (SECURITY_HOTSPOT.equals(rule.getType().name())) {
                return SonarQubeURLManager.getHotSpotsUrl(this.wsClient.wsConnector().baseUrl(), list.get(0), string2, string);
            }
            return SonarQubeURLManager.getIssuesUrl(this.wsClient.wsConnector().baseUrl(), list.get(0), string2, string3, string);
        }
        return SonarQubeURLManager.getIssuesMultiProjectUrl(this.wsClient.wsConnector().baseUrl(), list, list2, string2, string3);
    }

    private List<Issues.Issue> searchIssues(List<String> list, String string, String string2) {
        return this.searchIssues(list, string, string2, null);
    }

    private List<Issues.Issue> searchIssues(List<String> list, String string, String string2, String string3) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved("false");
        searchRequest.setFacets(Collections.singletonList("rules"));
        searchRequest.setAdditionalFields(Collections.singletonList("rules"));
        searchRequest.setPs("500");
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setBranch(string3);
        }
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setRules(Collections.singletonList(string2));
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
        arrayList.addAll(searchWsResponse.getIssuesList());
        if (searchWsResponse.getTotal() > 10000L) {
            LOGGER.warn("Found {} issues and SonarQube limit is 10000 issues. We will only return the first 10000 issues!", (Object)searchWsResponse.getTotal());
        }
        if (searchWsResponse.getTotal() > (long)searchWsResponse.getPs()) {
            int n = (int)Math.floor((double)searchWsResponse.getTotal() / (double)searchWsResponse.getPs()) + 1;
            n = Math.min(n, 20);
            for (int i = 2; i <= n; ++i) {
                searchRequest.setP("" + i);
                searchWsResponse = this.wsClient.issues().search(searchRequest);
                arrayList.addAll(searchWsResponse.getIssuesList());
            }
        }
        return arrayList;
    }

    private Issues.SearchWsResponse searchIssuesForTypeByAuthor(List<String> list, List<String> list2, String string) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setResolved("false");
        searchRequest.setFacets(Collections.singletonList("types"));
        if (list != null && !list.isEmpty()) {
            searchRequest.setProjects(list);
        }
        if (list2 != null && !list2.isEmpty()) {
            searchRequest.setAuthor(list2);
        }
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Issues.SearchWsResponse searchIssuesForRules(List<String> list, List<String> list2, String string, String string2, String string3) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setResolved("false");
        searchRequest.setFacets(Collections.singletonList("rules"));
        searchRequest.setAdditionalFields(Collections.singletonList("rules"));
        if (list != null && !list.isEmpty()) {
            searchRequest.setProjects(list);
        }
        if (list2 != null && !list2.isEmpty()) {
            searchRequest.setAuthor(list2);
        }
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setBranch(string3);
        }
        if (!string2.isEmpty()) {
            searchRequest.setRules(Collections.singletonList(string2));
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Issues.SearchWsResponse searchIssuesForRules(List<String> list, String string, String string2, String string3, String string4, String string5) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved("false");
        searchRequest.setFacets(Collections.singletonList("rules"));
        searchRequest.setAdditionalFields(Collections.singletonList("rules"));
        searchRequest.setCreatedAfter(string4);
        searchRequest.setCreatedBefore(string5);
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setBranch(string3);
        }
        if (!string2.isEmpty()) {
            searchRequest.setRules(Collections.singletonList(string2));
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Issues.SearchWsResponse searchIssuesForAuthors(List<String> list, String string, String string2, String string3, String string4) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved("false");
        searchRequest.setFacets(Collections.singletonList("authors"));
        searchRequest.setCreatedAfter(string3);
        searchRequest.setCreatedBefore(string4);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        return this.wsClient.issues().search(searchRequest);
    }

    public List<Issues.Issue> searchIssuesByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        GeneratedMessageV3 generatedMessageV3;
        LOGGER.debug("Searching issues by author: ({}) and branch ({})", (Object)list, (Object)string);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setResolved("false");
        searchRequest.setAuthor(list);
        searchRequest.setPs("500");
        if (list2 != null && !list2.isEmpty()) {
            searchRequest.setProjects(list2);
            if (list2.size() == 1) {
                if (string != null && !string.isEmpty()) {
                    searchRequest.setBranch(string);
                } else {
                    generatedMessageV3 = SonarQubeProjectManager.getProjectMainBranch(this.wsClient, SonarQubeProjectManager.getProjectBranches(this.wsClient, list2.get(0), this.userLocale), this.userLocale);
                    searchRequest.setBranch(((ProjectBranches.Branch)generatedMessageV3).getName());
                }
            }
        }
        generatedMessageV3 = this.wsClient.issues().search(searchRequest);
        ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
        arrayList.addAll(((Issues.SearchWsResponse)generatedMessageV3).getIssuesList());
        if (((Issues.SearchWsResponse)generatedMessageV3).getTotal() > 10000L) {
            LOGGER.warn("Found {} issues and SonarQube limit is 10000 issues. We will only return the first 10000 issues!", (Object)((Issues.SearchWsResponse)generatedMessageV3).getTotal());
        }
        if (((Issues.SearchWsResponse)generatedMessageV3).getTotal() > (long)((Issues.SearchWsResponse)generatedMessageV3).getPs()) {
            int n = (int)Math.floor((double)((Issues.SearchWsResponse)generatedMessageV3).getTotal() / (double)((Issues.SearchWsResponse)generatedMessageV3).getPs()) + 1;
            n = Math.min(n, 20);
            for (int i = 2; i <= n; ++i) {
                searchRequest.setP("" + i);
                generatedMessageV3 = this.wsClient.issues().search(searchRequest);
                arrayList.addAll(((Issues.SearchWsResponse)generatedMessageV3).getIssuesList());
            }
        }
        return arrayList;
    }

    private Issues.SearchWsResponse searchIssuesForProjects(List<String> list, String string, String string2, String string3, String string4) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved("false");
        searchRequest.setFacets(Collections.singletonList("projects"));
        searchRequest.setCreatedAfter(string3);
        searchRequest.setCreatedBefore(string4);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Map<String, Long> getBlockerRules(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, BLOCKER, string);
    }

    public Map<String, Long> getBugRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForType(null, list, BUG, string);
    }

    public Map<String, Long> getBugRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForType(list, list2, BUG, string);
    }

    public Map<String, Long> getVulnerabilityRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForType(null, list, VULNERABILITY, string);
    }

    public Map<String, Long> getVulnerabilityRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForType(list, list2, VULNERABILITY, string);
    }

    public Map<String, Long> getCodeSmellsRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForType(null, list, CODE_SMELL, string);
    }

    public Map<String, Long> getCodeSmellsRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForType(list, list2, CODE_SMELL, string);
    }

    public Map<String, Long> getBlockerRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, BLOCKER, string);
    }

    public Map<String, Long> getBlockerRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, BLOCKER, string);
    }

    private Map<String, Long> getCriticalRules(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, CRITICAL, string);
    }

    public Map<String, Long> getCriticalRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, CRITICAL, string);
    }

    public Map<String, Long> getCriticalRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, CRITICAL, string);
    }

    private Map<String, Long> getMajorRules(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, MAJOR, string);
    }

    public Map<String, Long> getMajorRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, MAJOR, string);
    }

    public Map<String, Long> getMajorRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, MAJOR, string);
    }

    private Map<String, Long> getMinorRules(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, MINOR, string);
    }

    public Map<String, Long> getMinorRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, MINOR, string);
    }

    public Map<String, Long> getMinorRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, MINOR, string);
    }

    public Map<String, Long> getInfoRules(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, INFO, string);
    }

    public Map<String, Long> getInfoRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, INFO, string);
    }

    public Map<String, Long> getInfoRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, INFO, string);
    }

    private Map<String, Long> sortByValue(Map<String, Long> map) {
        return map.entrySet().stream().sorted((entry, entry2) -> ((Long)entry2.getValue()).compareTo((Long)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, l2) -> l, LinkedHashMap::new));
    }
}

