/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.license.handler;

import com.bitegarden.license.pojo.BitegardenLicenseStatus;
import com.bitegarden.license.pojo.LicenseStatusResponse;
import com.bitegarden.license.utils.BitegardenLicenseChecker;
import com.bitegarden.licenser.common.data.DownloadInfo;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;

public class BitegardenLicenseServiceHandler
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitegardenLicenseServiceHandler.class);
    private final String pluginKey;
    private final BitegardenLicenseChecker checker;

    public BitegardenLicenseServiceHandler(BitegardenLicenseChecker bitegardenLicenseChecker, String string) {
        this.pluginKey = string;
        this.checker = bitegardenLicenseChecker;
    }

    public void handle(Request request, Response response) throws Exception {
        LOGGER.debug("Request license status from plugin ({})", (Object)this.pluginKey);
        LicenseStatusResponse licenseStatusResponse = new LicenseStatusResponse();
        try {
            licenseStatusResponse.setLicenseStatus(this.checker.getLicenseStatus());
            licenseStatusResponse.setUseRemainingDays(this.checker.getUseRemainingDays());
            licenseStatusResponse.setSupportRemainingDays(this.checker.getSupportRemainingDays());
            licenseStatusResponse.setDownloadInfo(this.checker.getDownloadInfo());
            response.stream().output().write(new Gson().toJson(licenseStatusResponse).getBytes());
        }
        catch (Exception exception) {
            LOGGER.error("Error getting license status for plugin ({}), reason -> {}", (Object)this.pluginKey, (Object)exception.getMessage());
            LOGGER.debug("Error getting license status for plugin ({})", (Object)this.pluginKey, (Object)exception);
            licenseStatusResponse.setLicenseStatus(BitegardenLicenseStatus.ERROR_READING_LICENSE);
            licenseStatusResponse.setUseRemainingDays(0L);
            licenseStatusResponse.setSupportRemainingDays(0L);
            licenseStatusResponse.setDownloadInfo(new DownloadInfo());
            licenseStatusResponse.setErrorMessage(exception.getMessage());
            response.stream().output().write(new Gson().toJson(licenseStatusResponse).getBytes());
        }
    }
}

