/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.io.PrintStream;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.BaseLogger;
import org.sonar.api.utils.log.ConsoleFormatter;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;

class ConsoleLogger
extends BaseLogger {
    private final PrintStream stream;

    ConsoleLogger() {
        this.stream = System.out;
    }

    ConsoleLogger(PrintStream stream) {
        this.stream = stream;
    }

    @Override
    public boolean isTraceEnabled() {
        return Loggers.getFactory().getLevel() == LoggerLevel.TRACE;
    }

    @Override
    protected void doTrace(String msg) {
        if (this.isTraceEnabled()) {
            this.log("TRACE", msg);
        }
    }

    @Override
    protected void doTrace(String pattern, @Nullable Object arg) {
        if (this.isTraceEnabled()) {
            this.doTrace(ConsoleFormatter.format(pattern, arg));
        }
    }

    @Override
    protected void doTrace(String pattern, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.isTraceEnabled()) {
            this.doTrace(ConsoleFormatter.format(pattern, arg1, arg2));
        }
    }

    @Override
    protected void doTrace(String pattern, Object ... args2) {
        if (this.isTraceEnabled()) {
            this.doTrace(ConsoleFormatter.format(pattern, args2));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        LoggerLevel level = Loggers.getFactory().getLevel();
        return level == LoggerLevel.TRACE || level == LoggerLevel.DEBUG;
    }

    @Override
    protected void doDebug(String msg) {
        if (this.isDebugEnabled()) {
            this.log("DEBUG", msg);
        }
    }

    @Override
    protected void doDebug(String pattern, @Nullable Object arg) {
        if (this.isDebugEnabled()) {
            this.doDebug(ConsoleFormatter.format(pattern, arg));
        }
    }

    @Override
    protected void doDebug(String pattern, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.isDebugEnabled()) {
            this.doDebug(ConsoleFormatter.format(pattern, arg1, arg2));
        }
    }

    @Override
    protected void doDebug(String pattern, Object ... args2) {
        if (this.isDebugEnabled()) {
            this.doDebug(ConsoleFormatter.format(pattern, args2));
        }
    }

    @Override
    protected void doInfo(String msg) {
        this.log("INFO ", msg);
    }

    @Override
    protected void doInfo(String pattern, @Nullable Object arg) {
        this.doInfo(ConsoleFormatter.format(pattern, arg));
    }

    @Override
    protected void doInfo(String pattern, @Nullable Object arg1, @Nullable Object arg2) {
        this.doInfo(ConsoleFormatter.format(pattern, arg1, arg2));
    }

    @Override
    protected void doInfo(String pattern, Object ... args2) {
        this.doInfo(ConsoleFormatter.format(pattern, args2));
    }

    @Override
    protected void doWarn(String msg) {
        this.log("WARN ", msg);
    }

    @Override
    void doWarn(String msg, Throwable thrown) {
        this.doWarn(msg);
        thrown.printStackTrace();
    }

    @Override
    protected void doWarn(String pattern, @Nullable Object arg) {
        this.doWarn(ConsoleFormatter.format(pattern, arg));
    }

    @Override
    protected void doWarn(String pattern, @Nullable Object arg1, @Nullable Object arg2) {
        this.doWarn(ConsoleFormatter.format(pattern, arg1, arg2));
    }

    @Override
    protected void doWarn(String pattern, Object ... args2) {
        this.doWarn(ConsoleFormatter.format(pattern, args2));
    }

    @Override
    protected void doError(String msg) {
        this.log("ERROR", msg);
    }

    @Override
    protected void doError(String pattern, @Nullable Object arg) {
        this.doError(ConsoleFormatter.format(pattern, arg));
    }

    @Override
    protected void doError(String pattern, @Nullable Object arg1, @Nullable Object arg2) {
        this.doError(ConsoleFormatter.format(pattern, arg1, arg2));
    }

    @Override
    protected void doError(String pattern, Object ... args2) {
        this.doError(ConsoleFormatter.format(pattern, args2));
    }

    @Override
    public void doError(String msg, Throwable thrown) {
        this.doError(msg);
        thrown.printStackTrace();
    }

    @Override
    public boolean setLevel(LoggerLevel level) {
        return false;
    }

    @Override
    public LoggerLevel getLevel() {
        return Loggers.getFactory().getLevel();
    }

    private void log(String level, String msg) {
        this.stream.println(String.format("%s %s", level, msg));
    }
}

