/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.System2;

public class Command {
    private final String executable;
    private final List<String> arguments = new ArrayList<String>();
    private final List<String> argumentsForLogs = new ArrayList<String>();
    private final Map<String, String> env;
    private File directory;
    private boolean newShell = false;
    private final System2 system;

    Command(String executable, System2 system) {
        Preconditions.checkArgument(!StringUtils.isBlank(executable), "Command executable can not be blank");
        this.executable = executable;
        this.env = new HashMap<String, String>(system.envVariables());
        this.system = system;
    }

    public static Command create(String executable) {
        return new Command(executable, System2.INSTANCE);
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public Command addArgument(String arg) {
        this.arguments.add(arg);
        this.argumentsForLogs.add(arg);
        return this;
    }

    public Command addMaskedArgument(String arg) {
        this.arguments.add(arg);
        this.argumentsForLogs.add("********");
        return this;
    }

    public Command addArguments(List<String> args2) {
        this.arguments.addAll(args2);
        this.argumentsForLogs.addAll(args2);
        return this;
    }

    public Command addArguments(String[] args2) {
        Collections.addAll(this.arguments, args2);
        Collections.addAll(this.argumentsForLogs, args2);
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Command setDirectory(File d2) {
        this.directory = d2;
        return this;
    }

    public Command setEnvironmentVariable(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.env);
    }

    public boolean isNewShell() {
        return this.newShell;
    }

    public Command setNewShell(boolean b2) {
        this.newShell = b2;
        return this;
    }

    List<String> toStrings(boolean forLogs) {
        ArrayList<String> command = new ArrayList<String>();
        if (this.newShell) {
            if (this.system.isOsWindows()) {
                command.add("cmd");
                command.add("/C");
                command.add("call");
            } else {
                command.add("sh");
            }
        }
        command.add(this.executable);
        command.addAll(forLogs ? this.argumentsForLogs : this.arguments);
        return Collections.unmodifiableList(command);
    }

    public String toCommandLine() {
        return String.join((CharSequence)" ", this.toStrings(false));
    }

    public String toString() {
        return String.join((CharSequence)" ", this.toStrings(true));
    }
}

