/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.XmlObjectBase;

public abstract class JavaIntegerHolder
extends XmlObjectBase {
    private BigInteger _value;
    private static final BigInteger _maxlong = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger _minlong = BigInteger.valueOf(Long.MIN_VALUE);

    @Override
    public SchemaType schemaType() {
        return BuiltinSchemaTypeSystem.ST_INTEGER;
    }

    @Override
    protected String compute_text(NamespaceManager nsm) {
        return this._value.toString();
    }

    @Override
    protected void set_text(String s2) {
        this.set_BigInteger(JavaIntegerHolder.lex(s2, _voorVc));
    }

    public static BigInteger lex(String s2, ValidationContext vc) {
        if (s2.length() > 0 && s2.charAt(0) == '+') {
            s2 = s2.substring(1);
        }
        try {
            return new BigInteger(s2);
        }
        catch (Exception e2) {
            vc.invalid("integer", new Object[]{s2});
            return null;
        }
    }

    @Override
    protected void set_nil() {
        this._value = null;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        this.check_dated();
        return this._value == null ? null : new BigDecimal(this._value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        this.check_dated();
        return this._value;
    }

    @Override
    protected void set_BigDecimal(BigDecimal v) {
        this._value = v.toBigInteger();
    }

    @Override
    protected void set_BigInteger(BigInteger v) {
        this._value = v;
    }

    @Override
    protected int compare_to(XmlObject i) {
        if (((SimpleValue)i).instanceType().getDecimalSize() > 1000000) {
            return -i.compareTo(this);
        }
        return this._value.compareTo(((XmlObjectBase)i).getBigIntegerValue());
    }

    @Override
    protected boolean equal_to(XmlObject i) {
        if (((SimpleValue)i).instanceType().getDecimalSize() > 1000000) {
            return i.valueEquals(this);
        }
        return this._value.equals(((XmlObjectBase)i).getBigIntegerValue());
    }

    @Override
    protected int value_hash_code() {
        if (this._value.compareTo(_maxlong) > 0 || this._value.compareTo(_minlong) < 0) {
            return this._value.hashCode();
        }
        long longval = this._value.longValue();
        return (int)((longval >> 32) * 19L + longval);
    }
}

