/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.xlsx;

import com.bitegarden.sonar.plugins.report.xlsx.XlsxReportField;
import com.bitegarden.sonar.plugins.report.xlsx.XlsxReportTab;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsxUtils {
    private static final int SUMMARY_SHEET_INDEX = 0;
    private static final int ISSUES_BY_RULE_SHEET_INDEX = 1;
    private static final int ISSUES_BREAKDOWN_SHEET_INDEX = 2;
    private static final int SECURITY_HOTSPOTS_BREAKDOWN_SHEET_INDEX = 3;
    private static final int PROJECT_NAME_ROW_INDEX = 6;
    private static final int PROJECT_NAME_COLUMN_INDEX = 2;
    private static final int BRANCH_NAME_ROW_INDEX = 6;
    private static final int BRANCH_NAME_COLUMN_INDEX = 10;
    private static final int SIZE_RATING_ROW_INDEX = 9;
    private static final int SIZE_RATING_COLUMN_INDEX = 2;
    private static final int NCLOC_ROW_INDEX = 9;
    private static final int NCLOC_COLUMN_INDEX = 4;
    private static final int PROJECT_VERSION_ROW_INDEX = 9;
    private static final int PROJECT_VERSION_COLUMN_INDEX = 10;
    private static final int LAST_ANALYSIS_ROW_INDEX = 6;
    private static final int LAST_ANALYSIS_COLUMN_INDEX = 16;
    private static final int QUALITY_GATE_ROW_INDEX = 9;
    private static final int QUALITY_GATE_COLUMN_INDEX = 16;
    private static final int RELIABILITY_RATING_ROW_INDEX = 13;
    private static final int RELIABILITY_RATING_COLUMN_INDEX = 2;
    private static final int SECURITY_RATING_ROW_INDEX = 13;
    private static final int SECURITY_RATING_COLUMN_INDEX = 8;
    private static final int MAINTAINABILITY_RATING_ROW_INDEX = 13;
    private static final int MAINTAINABILITY_RATING_COLUMN_INDEX = 14;
    private static final int BUGS_ROW_INDEX = 16;
    private static final int BUGS_COLUMN_INDEX = 2;
    private static final int VULNERABILITIES_ROW_INDEX = 16;
    private static final int VULNERABILITIES_COLUMN_INDEX = 8;
    private static final int CODE_SMELLS_ROW_INDEX = 16;
    private static final int CODE_SMELLS_COLUMN_INDEX = 14;
    private static final int SECURITY_HOTSPOTS_ROW_INDEX = 18;
    private static final int SECURITY_HOTSPOTS_COLUMN_INDEX = 8;
    private static final int DEBT_RATIO_ROW_INDEX = 18;
    private static final int DEBT_RATIO_COLUMN_INDEX = 14;
    private static final int RELIABILITY_RATING_NEW_CODE_ROW_INDEX = 21;
    private static final int RELIABILITY_RATING_NEW_CODE_COLUMN_INDEX = 2;
    private static final int SECURITY_RATING_NEW_CODE_ROW_INDEX = 21;
    private static final int SECURITY_RATING_NEW_CODE_COLUMN_INDEX = 8;
    private static final int MAINTAINABILITY_RATING_NEW_CODE_ROW_INDEX = 21;
    private static final int MAINTAINABILITY_RATING_NEW_CODE_COLUMN_INDEX = 14;
    private static final int BUGS_NEW_CODE_ROW_INDEX = 23;
    private static final int BUGS_NEW_CODE_COLUMN_INDEX = 2;
    private static final int VULNERABILITIES_NEW_CODE_ROW_INDEX = 23;
    private static final int VULNERABILITIES_NEW_CODE_COLUMN_INDEX = 8;
    private static final int CODE_SMELLS_NEW_CODE_ROW_INDEX = 23;
    private static final int CODE_SMELLS_NEW_CODE_COLUMN_INDEX = 14;
    private static final int SECURITY_HOTSPOTS_NEW_CODE_ROW_INDEX = 25;
    private static final int SECURITY_HOTSPOTS_NEW_CODE_COLUMN_INDEX = 8;
    private static final int DEBT_RATIO_NEW_CODE_ROW_INDEX = 25;
    private static final int DEBT_RATIO_NEW_CODE_COLUMN_INDEX = 14;
    private static final int BLOCKER_BUGS_ROW_INDEX = 30;
    private static final int BLOCKER_BUGS_COLUMN_INDEX = 2;
    private static final int BLOCKER_VULNERABILITIES_ROW_INDEX = 30;
    private static final int BLOCKER_VULNERABILITIES_COLUMN_INDEX = 3;
    private static final int BLOCKER_CODE_SMELLS_ROW_INDEX = 30;
    private static final int BLOCKER_CODE_SMELLS_COLUMN_INDEX = 4;
    private static final int CRITICAL_BUGS_ROW_INDEX = 32;
    private static final int CRITICAL_BUGS_COLUMN_INDEX = 2;
    private static final int CRITICAL_VULNERABILITIES_ROW_INDEX = 32;
    private static final int CRITICAL_VULNERABILITIES_COLUMN_INDEX = 3;
    private static final int CRITICAL_CODE_SMELLS_ROW_INDEX = 32;
    private static final int CRITICAL_CODE_SMELLS_COLUMN_INDEX = 4;
    private static final int MAJOR_BUGS_ROW_INDEX = 34;
    private static final int MAJOR_BUGS_COLUMN_INDEX = 2;
    private static final int MAJOR_VULNERABILITIES_ROW_INDEX = 34;
    private static final int MAJOR_VULNERABILITIES_COLUMN_INDEX = 3;
    private static final int MAJOR_CODE_SMELLS_ROW_INDEX = 34;
    private static final int MAJOR_CODE_SMELLS_COLUMN_INDEX = 4;
    private static final int MINOR_BUGS_ROW_INDEX = 36;
    private static final int MINOR_BUGS_COLUMN_INDEX = 2;
    private static final int MINOR_VULNERABILITIES_ROW_INDEX = 36;
    private static final int MINOR_VULNERABILITIES_COLUMN_INDEX = 3;
    private static final int MINOR_CODE_SMELLS_ROW_INDEX = 36;
    private static final int MINOR_CODE_SMELLS_COLUMN_INDEX = 4;
    private static final int INFO_BUGS_ROW_INDEX = 38;
    private static final int INFO_BUGS_COLUMN_INDEX = 2;
    private static final int INFO_VULNERABILITIES_ROW_INDEX = 38;
    private static final int INFO_VULNERABILITIES_COLUMN_INDEX = 3;
    private static final int INFO_CODE_SMELLS_ROW_INDEX = 38;
    private static final int INFO_CODE_SMELLS_COLUMN_INDEX = 4;
    private static final int COVERAGE_ROW_INDEX = 28;
    private static final int COVERAGE_COLUMN_INDEX = 8;
    private static final int DUPLICATIONS_ROW_INDEX = 28;
    private static final int DUPLICATIONS_COLUMN_INDEX = 14;
    private static final int UNIT_TESTS_ROW_INDEX = 33;
    private static final int UNIT_TESTS_COLUMN_INDEX = 8;
    private static final int DUPLICATED_BLOCKS_ROW_INDEX = 33;
    private static final int DUPLICATED_BLOCKS_COLUMN_INDEX = 14;
    private static final int COVERAGE_NEW_CODE_ROW_INDEX = 37;
    private static final int COVERAGE_NEW_CODE_COLUMN_INDEX = 8;
    private static final int DUPLICATIONS_NEW_CODE_ROW_INDEX = 37;
    private static final int DUPLICATIONS_NEW_CODE_COLUMN_INDEX = 14;
    private static Font arialFont;
    private static CellStyle cellStyle;
    private static final String DEFAULT_FONT_NAME = "Arial";

    private XlsxUtils() {
    }

    public static Sheet getSheet(Workbook workbook, XlsxReportTab xlsxReportTab) {
        if (workbook == null) {
            throw new IllegalArgumentException("Error getting sheet, workbook cannot be null");
        }
        switch (xlsxReportTab) {
            case SUMMARY: {
                return workbook.getSheetAt(0);
            }
            case ISSUES: {
                return workbook.getSheetAt(2);
            }
            case SECURITY_HOTSPOTS: {
                return workbook.getSheetAt(3);
            }
            case ISSUES_BY_RULE: {
                return workbook.getSheetAt(1);
            }
        }
        throw new IllegalArgumentException("Sheet not found");
    }

    public static Cell getCell(Sheet sheet, XlsxReportField xlsxReportField) {
        if (sheet == null) {
            throw new IllegalArgumentException("Error getting cell, sheet cannot be null");
        }
        switch (xlsxReportField) {
            case PROJECT_NAME: {
                return sheet.getRow(6).getCell(2);
            }
            case BRANCH_NAME: {
                return sheet.getRow(6).getCell(10);
            }
            case ANALYSIS_DATE: {
                return sheet.getRow(6).getCell(16);
            }
            case SIZE_RATING: {
                return sheet.getRow(9).getCell(2);
            }
            case NCLOC: {
                return sheet.getRow(9).getCell(4);
            }
            case PROJECT_VERSION: {
                return sheet.getRow(9).getCell(10);
            }
            case QUALITY_GATE: {
                return sheet.getRow(9).getCell(16);
            }
            case RELIABILITY_RATING: {
                return sheet.getRow(13).getCell(2);
            }
            case SECURITY_RATING: {
                return sheet.getRow(13).getCell(8);
            }
            case MAINTAINABILITY_RATING: {
                return sheet.getRow(13).getCell(14);
            }
            case BUGS: {
                return sheet.getRow(16).getCell(2);
            }
            case VULNERABILITIES: {
                return sheet.getRow(16).getCell(8);
            }
            case CODE_SMELLS: {
                return sheet.getRow(16).getCell(14);
            }
            case SECURITY_HOTSPOTS: {
                return sheet.getRow(18).getCell(8);
            }
            case DEBT_RATIO: {
                return sheet.getRow(18).getCell(14);
            }
            case RELIABILITY_NEW_CODE: {
                return sheet.getRow(21).getCell(2);
            }
            case SECURITY_NEW_CODE: {
                return sheet.getRow(21).getCell(8);
            }
            case MAINTAINABILITY_NEW_CODE: {
                return sheet.getRow(21).getCell(14);
            }
            case BUGS_NEW_CODE: {
                return sheet.getRow(23).getCell(2);
            }
            case VULNERABILITIES_NEW_CODE: {
                return sheet.getRow(23).getCell(8);
            }
            case CODE_SMELLS_NEW_CODE: {
                return sheet.getRow(23).getCell(14);
            }
            case SECURITY_HOTSPOTS_NEW_CODE: {
                return sheet.getRow(25).getCell(8);
            }
            case DEBT_RATIO_NEW_CODE: {
                return sheet.getRow(25).getCell(14);
            }
            case BLOCKER_BUGS: {
                return sheet.getRow(30).getCell(2);
            }
            case BLOCKER_VULNERABILITIES: {
                return sheet.getRow(30).getCell(3);
            }
            case BLOCKER_CODE_SMELLS: {
                return sheet.getRow(30).getCell(4);
            }
            case CRITICAL_BUGS: {
                return sheet.getRow(32).getCell(2);
            }
            case CRITICAL_VULNERABILITIES: {
                return sheet.getRow(32).getCell(3);
            }
            case CRITICAL_CODE_SMELLS: {
                return sheet.getRow(32).getCell(4);
            }
            case MAJOR_BUGS: {
                return sheet.getRow(34).getCell(2);
            }
            case MAJOR_VULNERABILITIES: {
                return sheet.getRow(34).getCell(3);
            }
            case MAJOR_CODE_SMELLS: {
                return sheet.getRow(34).getCell(4);
            }
            case MINOR_BUGS: {
                return sheet.getRow(36).getCell(2);
            }
            case MINOR_VULNERABILITIES: {
                return sheet.getRow(36).getCell(3);
            }
            case MINOR_CODE_SMELLS: {
                return sheet.getRow(36).getCell(4);
            }
            case INFO_BUGS: {
                return sheet.getRow(38).getCell(2);
            }
            case INFO_VULNERABILITIES: {
                return sheet.getRow(38).getCell(3);
            }
            case INFO_CODE_SMELLS: {
                return sheet.getRow(38).getCell(4);
            }
            case COVERAGE: {
                return sheet.getRow(28).getCell(8);
            }
            case DUPLICATIONS: {
                return sheet.getRow(28).getCell(14);
            }
            case UNIT_TESTS: {
                return sheet.getRow(33).getCell(8);
            }
            case DUPLICATED_BLOCKS: {
                return sheet.getRow(33).getCell(14);
            }
            case COVERAGE_NEW_CODE: {
                return sheet.getRow(37).getCell(8);
            }
            case DUPLICATIONS_NEW_CODE: {
                return sheet.getRow(37).getCell(14);
            }
        }
        throw new IllegalArgumentException("Cell not found");
    }

    public static Cell createCell(Workbook workbook, Row row, int n, HorizontalAlignment horizontalAlignment) {
        Cell cell = row.createCell(n);
        cell.setCellStyle(XlsxUtils.getCellStyle(workbook, horizontalAlignment));
        return cell;
    }

    private static Font getArialFont(Workbook workbook) {
        if (arialFont == null) {
            arialFont = workbook.createFont();
            arialFont.setFontName(DEFAULT_FONT_NAME);
        }
        return arialFont;
    }

    private static CellStyle getCellStyle(Workbook workbook, HorizontalAlignment horizontalAlignment) {
        if (cellStyle == null) {
            cellStyle = workbook.createCellStyle();
            cellStyle.setFont(XlsxUtils.getArialFont(workbook));
        }
        if (horizontalAlignment != null) {
            cellStyle.setAlignment(horizontalAlignment);
        }
        return cellStyle;
    }
}

