/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.pdf;

import com.bitegarden.sonar.plugins.report.util.PdfUtils;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class Fonts {
    private final PDFont regularFont;
    private final PDFont lightFont;
    private final PDFont boldFont;
    private final Font awtRegularFont;
    private final Font awtLightont;
    private final Font awtBoldFont;

    public Fonts(PDDocument pDDocument) throws IOException, FontFormatException {
        this.regularFont = PdfUtils.getFont(pDDocument, "/static/fonts/Roboto-Regular.ttf");
        this.lightFont = PdfUtils.getFont(pDDocument, "/static/fonts/Roboto-Light.ttf");
        this.boldFont = PdfUtils.getFont(pDDocument, "/static/fonts/Roboto-Bold.ttf");
        this.awtRegularFont = Font.createFont(0, Fonts.class.getResourceAsStream("/static/fonts/Roboto-Regular.ttf"));
        this.awtLightont = Font.createFont(0, Fonts.class.getResourceAsStream("/static/fonts/Roboto-Light.ttf"));
        this.awtBoldFont = Font.createFont(0, Fonts.class.getResourceAsStream("/static/fonts/Roboto-Bold.ttf"));
    }

    public Fonts(PDDocument pDDocument, String string, String string2, String string3) throws IOException, FontFormatException {
        this.regularFont = PdfUtils.getFont(pDDocument, string);
        this.lightFont = PdfUtils.getFont(pDDocument, string3);
        this.boldFont = PdfUtils.getFont(pDDocument, string2);
        this.awtRegularFont = Font.createFont(0, Fonts.class.getResourceAsStream(string));
        this.awtLightont = Font.createFont(0, Fonts.class.getResourceAsStream(string3));
        this.awtBoldFont = Font.createFont(0, Fonts.class.getResourceAsStream(string2));
    }

    public Fonts() {
        this.regularFont = PDType1Font.HELVETICA;
        this.lightFont = PDType1Font.HELVETICA;
        this.boldFont = PDType1Font.HELVETICA_BOLD;
        this.awtRegularFont = Font.getFont("SansSerif");
        this.awtLightont = Font.getFont("SansSerif");
        this.awtBoldFont = Font.getFont("SansSerif");
    }

    public PDFont getRegularFont() {
        return this.regularFont;
    }

    public PDFont getBoldFont() {
        return this.boldFont;
    }

    public PDFont getLightFont() {
        return this.lightFont;
    }

    public Font getAwtRegularFont() {
        return this.awtRegularFont;
    }

    public Font getAwtLightFont() {
        return this.awtLightont;
    }

    public Font getAwtBoldFont() {
        return this.awtBoldFont;
    }
}

