/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import org.knowm.xchart.BoxSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.BoxPlotData;
import org.knowm.xchart.internal.chartpart.BoxPlotDataCalculator;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.BoxStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Box<ST extends BoxStyler, S extends BoxSeries>
extends PlotContent_<ST, S> {
    private final ST boxPlotStyler;
    private double yMax;
    private double yMin;
    private double xLeftMargin;
    private double yTopMargin;
    private double yTickSpace;
    private double xOffset;
    private double yOffset;

    PlotContent_Box(Chart<ST, S> chart) {
        super(chart);
        this.boxPlotStyler = (BoxStyler)chart.getStyler();
    }

    @Override
    protected void doPaint(Graphics2D g2) {
        double xTickSpace = ((Styler)this.boxPlotStyler).getPlotContentSize() * this.getBounds().getWidth();
        this.xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        this.yTickSpace = ((Styler)this.boxPlotStyler).getPlotContentSize() * this.getBounds().getHeight();
        this.yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), this.yTickSpace);
        boolean toolTipsEnabled = ((BoxStyler)this.chart.getStyler()).isToolTipsEnabled();
        double gridStep = xTickSpace / (double)this.chart.getSeriesMap().size();
        BoxPlotDataCalculator boxPlotDataCalculator = new BoxPlotDataCalculator();
        List<BoxPlotData> boxPlotDataList = boxPlotDataCalculator.calculate(this.chart.getSeriesMap(), this.boxPlotStyler);
        BoxPlotData boxPlotData = null;
        int boxPlotCounter = -1;
        for (BoxSeries series : this.chart.getSeriesMap().values()) {
            if (!series.isEnabled()) continue;
            boxPlotData = boxPlotDataList.get(++boxPlotCounter);
            this.yMin = this.chart.getYAxis(series.getYAxisGroup()).getMin();
            this.yMax = this.chart.getYAxis(series.getYAxisGroup()).getMax();
            if (((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic()) {
                this.yMin = Math.log10(this.yMin);
                this.yMax = Math.log10(this.yMax);
            }
            Collection<? extends Number> yData = series.getYData();
            for (Number number : yData) {
                double yOrig = number.doubleValue();
                double y = ((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                double yTransfrom = this.getBounds().getHeight() - (this.yTopMargin + (y - this.yMin) / (this.yMax - this.yMin) * this.yTickSpace);
                if (Math.abs(this.yMax - this.yMin) / 5.0 == 0.0) {
                    yTransfrom = this.getBounds().getHeight() / 2.0;
                }
                this.xOffset = this.getBounds().getX() + this.xLeftMargin + (double)boxPlotCounter * gridStep + gridStep / 2.0;
                this.yOffset = this.getBounds().getY() + yTransfrom;
                if (yOrig > boxPlotData.upper || yOrig < boxPlotData.lower) {
                    Line2D.Double outPointLine1 = new Line2D.Double(this.xOffset - (double)((Styler)this.boxPlotStyler).getMarkerSize(), this.yOffset, this.xOffset + (double)((Styler)this.boxPlotStyler).getMarkerSize(), this.yOffset);
                    Line2D.Double outPointLine2 = new Line2D.Double(this.xOffset, this.yOffset - (double)((Styler)this.boxPlotStyler).getMarkerSize(), this.xOffset, this.yOffset + (double)((Styler)this.boxPlotStyler).getMarkerSize());
                    g2.setColor(Color.RED);
                    g2.setStroke(new BasicStroke(1.0f, 0, 2));
                    g2.draw(outPointLine1);
                    g2.draw(outPointLine2);
                    if (!toolTipsEnabled) continue;
                    this.toolTips.addData(this.xOffset, this.yOffset, series.getName() + ":" + System.lineSeparator() + this.chart.getYAxisFormat().format(yOrig));
                    continue;
                }
                if (!((BoxStyler)this.chart.getStyler()).getShowWithinAreaPoint()) continue;
                g2.setColor(series.getMarkerColor());
                series.getMarker().paint(g2, this.xOffset, this.yOffset, ((Styler)this.boxPlotStyler).getMarkerSize());
                if (!toolTipsEnabled) continue;
                this.toolTips.addData(this.xOffset, this.yOffset, series.getName() + ":" + System.lineSeparator() + this.chart.getYAxisFormat().format(yOrig));
            }
            this.drawBoxPlot(g2, series.getName(), boxPlotData);
        }
    }

    private void drawBoxPlot(Graphics2D g2, String seriesName, BoxPlotData boxPlotData) {
        double q1YOffset = this.getBounds().getY() + this.getBounds().getHeight() - (this.yTopMargin + ((((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic() ? Math.log10(boxPlotData.q1) : boxPlotData.q1) - this.yMin) / (this.yMax - this.yMin) * this.yTickSpace);
        double medianYOffset = this.getBounds().getY() + this.getBounds().getHeight() - (this.yTopMargin + ((((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic() ? Math.log10(boxPlotData.median) : boxPlotData.median) - this.yMin) / (this.yMax - this.yMin) * this.yTickSpace);
        double q3YOffset = this.getBounds().getY() + this.getBounds().getHeight() - (this.yTopMargin + ((((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic() ? Math.log10(boxPlotData.q3) : boxPlotData.q3) - this.yMin) / (this.yMax - this.yMin) * this.yTickSpace);
        double upperYOffset = this.getBounds().getY() + this.getBounds().getHeight() - (this.yTopMargin + ((((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic() ? Math.log10(boxPlotData.upper) : boxPlotData.upper) - this.yMin) / (this.yMax - this.yMin) * this.yTickSpace);
        double lowerYOffset = this.getBounds().getY() + this.getBounds().getHeight() - (this.yTopMargin + ((((AxesChartStyler)this.boxPlotStyler).isYAxisLogarithmic() ? Math.log10(boxPlotData.lower) : boxPlotData.lower) - this.yMin) / (this.yMax - this.yMin) * this.yTickSpace);
        Line2D.Double middleline = new Line2D.Double(this.xOffset - this.xLeftMargin, medianYOffset, this.xOffset + this.xLeftMargin, medianYOffset);
        Line2D.Double maxLine = new Line2D.Double(this.xOffset - this.xLeftMargin / 2.0, upperYOffset, this.xOffset + this.xLeftMargin / 2.0, upperYOffset);
        Line2D.Double minLine = new Line2D.Double(this.xOffset - this.xLeftMargin / 2.0, lowerYOffset, this.xOffset + this.xLeftMargin / 2.0, lowerYOffset);
        Line2D.Double upLine = new Line2D.Double(this.xOffset, upperYOffset, this.xOffset, q3YOffset);
        Line2D.Double lowLine = new Line2D.Double(this.xOffset, lowerYOffset, this.xOffset, q1YOffset);
        Rectangle2D.Double rect = new Rectangle2D.Double(this.xOffset - this.xLeftMargin, q3YOffset, 2.0 * this.xLeftMargin, q1YOffset - q3YOffset);
        g2.setColor(Color.BLUE);
        g2.setStroke(new BasicStroke(1.0f, 0, 2));
        g2.draw(rect);
        g2.setColor(Color.RED);
        g2.draw(middleline);
        g2.setColor(Color.BLACK);
        g2.draw(maxLine);
        g2.draw(minLine);
        g2.setStroke(new BasicStroke(1.0f, 0, 1, 6.0f, new float[]{4.0f, 0.0f, 4.0f}, 6.0f));
        g2.draw(upLine);
        g2.draw(lowLine);
        Area area = new Area();
        area.add(new Area(maxLine.getBounds()));
        area.add(new Area(maxLine.getBounds()));
        area.add(new Area(minLine.getBounds()));
        area.add(new Area(upLine.getBounds()));
        area.add(new Area(lowLine.getBounds()));
        area.add(new Area(rect.getBounds()));
        if (((Styler)this.boxPlotStyler).isToolTipsEnabled()) {
            this.toolTips.addData(area, this.xOffset, this.yOffset, 10.0, seriesName + ":" + System.lineSeparator() + "upper: " + this.chart.getYAxisFormat().format(boxPlotData.upper) + System.lineSeparator() + "q3: " + this.chart.getYAxisFormat().format(boxPlotData.q3) + System.lineSeparator() + "median: " + this.chart.getYAxisFormat().format(boxPlotData.median) + System.lineSeparator() + "q1: " + this.chart.getYAxisFormat().format(boxPlotData.q1) + System.lineSeparator() + "lower: " + this.chart.getYAxisFormat().format(boxPlotData.lower));
        }
    }
}

