/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.utils;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FormatUtils {
    private FormatUtils() {
    }

    public static NumberFormat getNumber() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        return numberFormat;
    }

    public static NumberFormat getNumber(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        return numberFormat;
    }

    public static NumberFormat getPercentage() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(1);
        return numberFormat;
    }

    public static NumberFormat getPercentage(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        return numberFormat;
    }

    public static String toRating(double d2, double d3, double d4, double d5, double d6, String string) {
        if (d2 < d3) {
            return "A";
        }
        if (d2 < d4) {
            return "B";
        }
        if (d2 < d5) {
            return "C";
        }
        if (d2 < d6) {
            return "D";
        }
        if (d2 > d6) {
            return "E";
        }
        return string;
    }

    public static String duplicatedLinesToRating(double d2) {
        return FormatUtils.toRating(d2, 3.0, 5.0, 10.0, 20.0, "E");
    }

    public static String coverageToRating(Double d2) {
        if (d2 == null) {
            return "NO_DATA";
        }
        if (d2 < 30.0) {
            return "E";
        }
        if (d2 < 50.0) {
            return "D";
        }
        if (d2 < 70.0) {
            return "C";
        }
        if (d2 < 80.0) {
            return "B";
        }
        return "A";
    }

    public static DateFormat getDate() {
        return DateFormat.getDateInstance(2);
    }

    public static DateFormat getDate(Locale locale) {
        return DateFormat.getDateInstance(2, locale);
    }

    public static String toRating(String string) {
        if ("1.0".equals(string)) {
            return "A";
        }
        if ("2.0".equals(string)) {
            return "B";
        }
        if ("3.0".equals(string)) {
            return "C";
        }
        if ("4.0".equals(string)) {
            return "D";
        }
        if ("5.0".equals(string)) {
            return "E";
        }
        return "A";
    }

    public static String toRating(Long l) {
        double d2 = Math.round(l.longValue());
        if (d2 == 1.0) {
            return "A";
        }
        if (d2 == 2.0) {
            return "B";
        }
        if (d2 == 3.0) {
            return "C";
        }
        if (d2 == 4.0) {
            return "D";
        }
        if (d2 == 5.0) {
            return "E";
        }
        return "A";
    }

    public static double ratingToDouble(String string) {
        if ("A".equals(string)) {
            return 1.0;
        }
        if ("B".equals(string)) {
            return 2.0;
        }
        if ("C".equals(string)) {
            return 3.0;
        }
        if ("D".equals(string)) {
            return 4.0;
        }
        return 5.0;
    }

    public static String doubleToRating(double d2) {
        double d3 = Math.round(d2);
        if (d3 == 1.0) {
            return "A";
        }
        if (d3 == 2.0) {
            return "B";
        }
        if (d3 == 3.0) {
            return "C";
        }
        if (d3 == 4.0) {
            return "D";
        }
        return "E";
    }

    public static String toSizeRating(String string) {
        Long l = Long.parseLong(string);
        if (l < 1000L) {
            return "XS";
        }
        if (l >= 1000L && l < 10000L) {
            return "S";
        }
        if (l >= 10000L && l < 100000L) {
            return "M";
        }
        if (l >= 100000L && l < 500000L) {
            return "L";
        }
        return "XL";
    }

    public static String toSizeRating(Double d2) {
        if (d2 < 1000.0) {
            return "XS";
        }
        if (d2 >= 1000.0 && d2 < 10000.0) {
            return "S";
        }
        if (d2 >= 10000.0 && d2 < 100000.0) {
            return "M";
        }
        if (d2 >= 100000.0 && d2 < 500000.0) {
            return "L";
        }
        return "XL";
    }

    public static String toSizeRating(Long l) {
        if (l < 1000L) {
            return "XS";
        }
        if (l >= 1000L && l < 10000L) {
            return "S";
        }
        if (l >= 10000L && l < 100000L) {
            return "M";
        }
        if (l >= 100000L && l < 500000L) {
            return "L";
        }
        return "XL";
    }

    public static String toCoverageRating(Double d2) {
        if (d2 == null) {
            return "NO_DATA";
        }
        if (d2 < 30.0) {
            return "E";
        }
        if (d2 < 50.0) {
            return "D";
        }
        if (d2 < 70.0) {
            return "C";
        }
        if (d2 < 80.0) {
            return "B";
        }
        return "A";
    }

    public static String toDuplicationsRating(Double d2) {
        return FormatUtils.duplicatedLinesToRating(d2);
    }

    public static String toHealthRating(Long l) {
        if (l < 20L) {
            return "E";
        }
        if (l < 40L) {
            return "D";
        }
        if (l < 60L) {
            return "C";
        }
        if (l < 80L) {
            return "B";
        }
        return "A";
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Map<String, String>> formatProjectMeasuresMap(Map<String, Map<String, Long>> map, Locale locale) {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, Long>> entry : map.entrySet()) {
            void object22;
            Object object;
            String string;
            String string2 = entry.getKey();
            Map<String, Long> map2 = entry.getValue();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            for (Map.Entry<String, Long> entry2 : map2.entrySet()) {
                String string3;
                string = entry2.getKey();
                object = entry2.getValue();
                if (string.equals("reliability_rating") || string.equals("security_rating") || string.equals("sqale_rating") || string.equals("security_review_rating")) {
                    string3 = FormatUtils.toRating((Long)object);
                } else if (string.equals("alert_status")) {
                    string3 = "ERROR";
                    if ((Long)object == 1L) {
                        string3 = "OK";
                    } else if ((Long)object == 2L) {
                        string3 = "NONE";
                    }
                } else {
                    string3 = FormatUtils.getNumber(locale).format(object);
                }
                hashMap2.put(string, string3);
            }
            Object object3 = (double)(map2.get("conditions_to_cover") - map2.get("uncovered_conditions") + map2.get("lines_to_cover") - map2.get("uncovered_lines")) / (double)(map2.get("conditions_to_cover") + map2.get("lines_to_cover"));
            if (((Double)object3).isNaN()) {
                object3 = 0.0;
            }
            hashMap2.put("coverage", FormatUtils.getPercentage(locale).format(object3));
            hashMap2.put("coveragePercent", FormatUtils.getPercentage(locale).format((Double)object3 * 100.0));
            hashMap2.put("uncoveredPercent", FormatUtils.getPercentage(locale).format((1.0 - (Double)object3) * 100.0));
            Double d2 = (double)map2.get("duplicated_lines").longValue() / (double)map2.get("lines").longValue();
            if (d2.isNaN()) {
                Double d3 = 0.0;
            }
            hashMap2.put("duplications", FormatUtils.getPercentage(locale).format(object22));
            string = FormatUtils.toDuplicationsRating(object22.doubleValue() * 100.0);
            hashMap2.put("duplicationsRating", string);
            object = FormatUtils.toSizeRating(map2.get("ncloc"));
            hashMap2.put("sizeRating", object);
            hashMap.put(string2, hashMap2);
        }
        return hashMap;
    }

    public static Map<String, String> formatLongMeasuresMap(Map<String, Long> map, Locale locale) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            String string = entry.getKey();
            Long l = entry.getValue();
            String string2 = FormatUtils.getNumber(locale).format(l);
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

