/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import es.sonarqube.api.SonarQubeLanguage;
import es.sonarqube.api.SonarQubeLanguagesResponse;
import es.sonarqube.api.SonarQubeOverviewSummary;
import es.sonarqube.api.SonarQubeProjectSummary;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.managers.SonarQubeURLManager;
import es.sonarqube.utils.FormatUtils;
import es.sonarqube.utils.MapUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.KeyValueFormat;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Components;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.Measures;
import org.sonarqube.ws.ProjectTags;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.components.SearchProjectsRequest;
import org.sonarqube.ws.client.languages.ListRequest;
import org.sonarqube.ws.client.measures.ComponentRequest;
import org.sonarqube.ws.client.measures.SearchRequest;

public class SonarQubeOverviewManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeOverviewManager.class);
    private final WsClient wsClient;
    private final Locale userLocale;
    private final String serverVersion;
    public static final String DEBUG_TOTAL_PROJECTS_MESSAGE = "Total projects found: {}";
    public static final String DEBUG_PAGE_SIZE_500_MESSAGE = "Page size:            500";
    public static final String DEBUG_TOTAL_PAGES_MESSAGE = "Total pages:          {}";
    public static final String DEBUG_REQUESTING_PAGE = "Requesting page {} of {}";
    public static final String DEBUG_ISSUE_COUNT_PER_RULE_MESSAGE = "--> {} for rule: {}";
    public static final String DEBUG_UNABLE_TO_GET_RULE = "Unable to get rule {}: {}";
    public static final String MAP_COVERAGE_PERCENT = "coveragePercent";
    public static final String MAP_UNCOVERED_PERCENT = "uncoveredPercent";
    public static final String MAP_DUPLICATIONS = "duplications";
    public static final String MAP_DUPLICATIONS_RATING = "duplicationsRating";
    public static final String MAP_DUPLICATIONS_RATING_DISTRIBUTION = "duplicationsRatingDistribution";
    public static final String MAP_SIZE_RATING = "sizeRating";
    public static final String MAP_SIZE_RATING_DISTRIBUTION = "sizeRatingDistribution";
    public static final String MAP_MAINTAINABILITY_RATING = "maintainabilityRating";
    public static final String MAP_MAINTAINABILITY_RATING_DISTRIBUTION = "maintainabilityRatingDistribution";
    public static final String MAP_SECURITY_RATING = "securityRating";
    public static final String MAP_SECURITY_RATING_DISTRIBUTION = "securityRatingDistribution";
    public static final String MAP_SECURITY_REVIEW_RATING = "securityReviewRating";
    public static final String MAP_SECURITY_REVIEW_RATING_DISTRIBUTION = "securityReviewRatingDistribution";
    public static final String MAP_RELIABILITY_RATING = "reliabilityRating";
    public static final String MAP_RELIABILITY_RATING_DISTRIBUTION = "reliabilityRatingDistribution";
    public static final String MAP_COVERAGE_RATING_DISTRIBUTION = "coverageRatingDistribution";
    public static final String MAP_TOTAL_PROJECTS = "totalProjects";
    public static final String MAP_HEALTH_RATING = "healthRating";
    public static final String MAP_HEALTH_RATING_DISTRIBUTION = "qualityGateDistribution";
    public static final String MAP_MEASURES = "measures";
    public static final String MAP_LOCALE_MEASURES = "formattedMeasures";
    public static final String MAP_ISSUES = "issues";
    public static final String MAP_NO_DATA = "NO_DATA";
    public static final String MAP_NO_DATA_SUFFIX = "_NO_DATA";
    public static final String BOOLEAN_FALSE_STRING = "false";
    public static final String FILTER_TRK_QUALIFIER = "qualifier=TRK";
    public static final String SEVERITY_BLOCKER = "BLOCKER";
    public static final String SEVERITY_CRITICAL = "CRITICAL";
    public static final String SEVERITY_MAJOR = "MAJOR";
    public static final String SEVERITY_MINOR = "MINOR";
    public static final String SEVERITY_INFO = "INFO";
    public static final String STATUS_ERROR = "ERROR";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_NONE = "NONE";
    public static final String FACET_LANGUAGES = "languages";
    protected static final List<String> OVERVIEW_FACETS = Arrays.asList("reliability_rating", "sqale_rating", "security_rating", "languages", "coverage", "duplicated_lines_density", "ncloc", "alert_status");

    public SonarQubeOverviewManager(WsClient wsClient, Locale locale) throws SonarQubeException {
        this.wsClient = wsClient;
        this.userLocale = locale;
        this.serverVersion = SonarQubeServerManager.getSonarQubeVersion(wsClient);
    }

    public SonarQubeOverviewManager(String string, String string2, Locale locale) throws SonarQubeException {
        this.userLocale = locale;
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
        this.serverVersion = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
    }

    public SonarQubeOverviewSummary getOverviewSummary() {
        Map<String, Object> map = this.generateMeasureDataForMainBranch(this.getAllProjectKeys());
        return new SonarQubeOverviewSummary(map);
    }

    public SonarQubeOverviewSummary getOverviewSummary(String string) {
        Map<String, Object> map = string == null ? this.generateMeasureDataForMainBranch(this.getAllProjectKeys()) : this.generateMeasureDataForBranch(this.getAllProjectKeys(), string);
        return new SonarQubeOverviewSummary(map);
    }

    public SonarQubeOverviewSummary getOverviewSummary(List<String> list) {
        return this.getOverviewSummary(list, null);
    }

    public SonarQubeOverviewSummary getOverviewSummary(List<String> list, String string) {
        Map<String, Object> map = string == null ? this.generatePortfolioMeasureDataForMainBranch(list) : this.generateMeasureDataForBranch(list, string);
        return new SonarQubeOverviewSummary(map);
    }

    public List<SonarQubeProjectSummary> getOverviewProjectMeasures() {
        return this.getOverviewProjectMeasures(this.getAllProjectKeys());
    }

    public List<SonarQubeProjectSummary> getOverviewProjectMeasures(List<String> list) {
        Map<String, Map<String, Long>> map = this.getProjectMeasures(list, Arrays.asList("ncloc", "ncloc_language_distribution", "bugs", "vulnerabilities", "security_hotspots", "code_smells", "duplicated_lines", "lines", "conditions_to_cover", "uncovered_conditions", "lines_to_cover", "uncovered_lines", "reliability_rating", "security_rating", "security_review_rating", "sqale_rating", "alert_status"));
        Map<String, Map<String, String>> map2 = FormatUtils.formatProjectMeasuresMap(map, this.userLocale);
        Map<String, Map<String, String>> map3 = this.getProjectInformation(list);
        List<String> list2 = this.getLanguageKeys();
        ArrayList<SonarQubeProjectSummary> arrayList = new ArrayList<SonarQubeProjectSummary>();
        for (String string : list) {
            if (!map.containsKey(string)) continue;
            Map<String, String> map4 = map2.get(string);
            Map<String, String> map5 = map3.getOrDefault(string, this.getDefaultProjectInformation(string));
            SonarQubeProjectSummary sonarQubeProjectSummary = new SonarQubeProjectSummary(string, map4, map5);
            sonarQubeProjectSummary.setLanguageDistribution(this.getLanguageDistributionFromMeasuresMap(map4, list2));
            sonarQubeProjectSummary.setUrl(SonarQubeURLManager.getProjectUrl(this.wsClient.wsConnector().baseUrl(), string, this.serverVersion));
            arrayList.add(sonarQubeProjectSummary);
        }
        return arrayList;
    }

    private Map<String, String> getLanguageDistributionFromMeasuresMap(Map<String, String> map, List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            if (!map.containsKey(string)) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    private List<String> getLanguageKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListRequest listRequest = new ListRequest();
        String string = this.wsClient.languages().list(listRequest);
        SonarQubeLanguagesResponse sonarQubeLanguagesResponse = new Gson().fromJson(string, SonarQubeLanguagesResponse.class);
        for (SonarQubeLanguage sonarQubeLanguage : sonarQubeLanguagesResponse.getLanguages()) {
            arrayList.add(sonarQubeLanguage.getKey());
        }
        LOGGER.debug("available languages: {}", (Object)arrayList);
        return arrayList;
    }

    private Map<String, String> getDefaultProjectInformation(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        hashMap.put("date", "");
        return hashMap;
    }

    public List<String> getAllProjectKeys() {
        Object object;
        Instant instant = Instant.now();
        SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
        if (!SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) && !this.isSonarQubePrevious8x3()) {
            searchProjectsRequest.setFilter(FILTER_TRK_QUALIFIER);
        }
        searchProjectsRequest.setPs("500");
        Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Components.Component serializable : searchProjectsWsResponse.getComponentsList()) {
            if (SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) || this.isSonarQubePrevious8x3() || serializable.getQualifier().equals("TRK")) {
                arrayList.add(serializable.getKey());
                continue;
            }
            LOGGER.warn("Ignoring {} as it is not a project, qualifier is {}", (Object)serializable.getKey(), (Object)serializable.getQualifier());
        }
        if (searchProjectsWsResponse.hasPaging()) {
            object = searchProjectsWsResponse.getPaging().getTotal();
            LOGGER.debug(DEBUG_TOTAL_PROJECTS_MESSAGE, object);
            LOGGER.debug(DEBUG_PAGE_SIZE_500_MESSAGE);
            if ((Integer)object > 10000) {
                LOGGER.warn("Found {} projects and limit is 10000 projects. We will only return the first 10000 projects!", object);
            }
            Double l = Math.ceil((double)((Integer)object).intValue() / 500.0);
            LOGGER.debug(DEBUG_TOTAL_PAGES_MESSAGE, (Object)l);
            Double d2 = Math.min(l, 20.0);
            int n = 2;
            while ((double)n <= d2) {
                LOGGER.debug(DEBUG_REQUESTING_PAGE, (Object)n, (Object)d2);
                searchProjectsRequest = new SearchProjectsRequest();
                if (!SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) && !this.isSonarQubePrevious8x3()) {
                    searchProjectsRequest.setFilter(FILTER_TRK_QUALIFIER);
                }
                searchProjectsRequest.setPs("500");
                searchProjectsRequest.setP(Integer.toString(n));
                searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                    if ((SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) || this.isSonarQubePrevious8x3() || component.getQualifier().equals("TRK")) && !arrayList.contains(component.getKey())) {
                        arrayList.add(component.getKey());
                        continue;
                    }
                    LOGGER.warn("Ignoring {} as it is not a project, qualifier is {}", (Object)component.getKey(), (Object)component.getQualifier());
                }
                ++n;
            }
        }
        object = Instant.now();
        long l = Duration.between(instant, (Temporal)object).toMillis() / 1000L;
        LOGGER.debug("Total projects retrieved: {} ( Elapsed time: {} s )", (Object)arrayList.size(), (Object)l);
        return arrayList;
    }

    public Map<String, Map<String, String>> getProjectInformation(List<String> list) {
        Comparable<Instant> comparable;
        Instant instant = Instant.now();
        LOGGER.debug("Getting project information for {} projects... ", (Object)list.size());
        boolean bl = SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl());
        SearchProjectsRequest searchProjectsRequest = this.getSearchProjectsRequest(bl);
        Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>(SonarQubeOverviewManager.getProjectInformationParams(list, searchProjectsWsResponse));
        if (searchProjectsWsResponse.hasPaging()) {
            comparable = searchProjectsWsResponse.getPaging().getTotal();
            LOGGER.debug(DEBUG_TOTAL_PROJECTS_MESSAGE, (Object)comparable);
            LOGGER.debug(DEBUG_PAGE_SIZE_500_MESSAGE);
            double d2 = Math.ceil((double)((Integer)comparable).intValue() / 500.0);
            LOGGER.debug(DEBUG_TOTAL_PAGES_MESSAGE, (Object)d2);
            if (SonarQubeOverviewManager.searchProjectsOneByOne(list, bl, d2)) {
                for (String string : list) {
                    if (hashMap.containsKey(string)) {
                        LOGGER.debug("Project information already retrieved for {}", (Object)string);
                        continue;
                    }
                    LOGGER.debug("Requesting project information for {}", (Object)string);
                    searchProjectsRequest.setFilter(String.format("query=%s", string));
                    searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                    hashMap.putAll(SonarQubeOverviewManager.getProjectInformationParams(list, searchProjectsWsResponse));
                }
            } else {
                int n = 2;
                while ((double)n <= d2) {
                    LOGGER.debug(DEBUG_REQUESTING_PAGE, (Object)n, (Object)d2);
                    searchProjectsRequest.setP(Integer.toString(n));
                    searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                    hashMap.putAll(SonarQubeOverviewManager.getProjectInformationParams(list, searchProjectsWsResponse));
                    ++n;
                }
            }
        }
        comparable = Instant.now();
        long l = Duration.between(instant, (Temporal)((Object)comparable)).toMillis() / 1000L;
        LOGGER.debug("Project information retrieved for {} projects", (Object)hashMap.size());
        LOGGER.debug("Elapsed time to get project information: {} ms   ({} s)", (Object)l, (Object)(l / 1000L));
        return hashMap;
    }

    private static boolean searchProjectsOneByOne(List<String> list, boolean bl, double d2) {
        return d2 > (double)list.size() || bl;
    }

    @NotNull
    private SearchProjectsRequest getSearchProjectsRequest(boolean bl) {
        SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
        searchProjectsRequest.setPs("500");
        if (!bl && !this.isSonarQubePrevious8x3()) {
            searchProjectsRequest.setFilter(FILTER_TRK_QUALIFIER);
        }
        searchProjectsRequest.setF(Collections.singletonList("_all"));
        return searchProjectsRequest;
    }

    private static Map<String, Map<String, String>> getProjectInformationParams(List<String> list, Components.SearchProjectsWsResponse searchProjectsWsResponse) {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
            if (!list.contains(component.getKey())) continue;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("name", component.getName());
            hashMap2.put("date", component.getAnalysisDate());
            hashMap.put(component.getKey(), hashMap2);
        }
        return hashMap;
    }

    public Map<String, Long> getTotalMeasures(List<String> list, List<String> list2) {
        Instant instant = Instant.now();
        LOGGER.debug("Getting total measures for {} projects", (Object)list.size());
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (String object2 : list2) {
            hashMap.put(object2, 0L);
        }
        hashMap.put(STATUS_OK, 0L);
        hashMap.put(STATUS_ERROR, 0L);
        List<List<String>> list3 = Lists.partition(list, 100);
        Iterator iterator2 = list3.iterator();
        while (iterator2.hasNext()) {
            List list4 = (List)iterator2.next();
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.setMetricKeys(list2);
            searchRequest.setProjectKeys(list4);
            Measures.SearchWsResponse searchWsResponse = this.wsClient.measures().search(searchRequest);
            for (Measures.Measure measure : searchWsResponse.getMeasuresList()) {
                Long l;
                Long l2;
                Long l3;
                Object object;
                Object object2;
                LOGGER.trace("Key: {} ... Value: {}", (Object)measure.getMetric(), (Object)measure.getValue());
                if (measure.getMetric().equals("ncloc_language_distribution")) {
                    Map<String, String> d2 = KeyValueFormat.parse(measure.getValue());
                    object2 = d2.keySet().iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        l3 = Long.parseLong(d2.get(object));
                        if (hashMap.containsKey(object)) {
                            l2 = (Long)hashMap.get(object);
                            l2 = l2 + l3;
                            hashMap.put((String)object, l2);
                            continue;
                        }
                        hashMap.put((String)object, l3);
                    }
                    continue;
                }
                if (measure.getMetric().equals("reliability_rating") || measure.getMetric().equals("security_rating") || measure.getMetric().equals("sqale_rating") || measure.getMetric().equals("security_review_rating")) {
                    Long numberFormatException = hashMap.getOrDefault(measure.getMetric(), 0L);
                    object2 = (long)Double.parseDouble(measure.getValue());
                    numberFormatException = numberFormatException + (Long)object2;
                    hashMap.put(measure.getMetric(), numberFormatException);
                    object = measure.getMetric() + "_" + FormatUtils.toRating((Long)object2);
                    if (hashMap.containsKey(object)) {
                        l2 = l3 = (Long)hashMap.get(object);
                        l = l3 = Long.valueOf(l3 + 1L);
                        hashMap.put((String)object, l3);
                        continue;
                    }
                    hashMap.put((String)object, 1L);
                    continue;
                }
                if (measure.getMetric().equals("duplicated_lines_density")) {
                    try {
                        double d3 = Double.parseDouble(measure.getValue());
                        object = "duplications_rating_" + FormatUtils.toDuplicationsRating(d3);
                        if (hashMap.containsKey(object)) {
                            l2 = l3 = (Long)hashMap.get(object);
                            l = l3 = Long.valueOf(l3 + 1L);
                            hashMap.put((String)object, l3);
                            continue;
                        }
                        hashMap.put((String)object, 1L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error parsing measure", numberFormatException);
                    }
                    continue;
                }
                if (measure.getMetric().equals("coverage")) {
                    try {
                        double string = Double.parseDouble(measure.getValue());
                        object = "coverage_rating_" + FormatUtils.toCoverageRating(string);
                        if (hashMap.containsKey(object)) {
                            l2 = l3 = (Long)hashMap.get(object);
                            l = l3 = Long.valueOf(l3 + 1L);
                            hashMap.put((String)object, l3);
                            continue;
                        }
                        hashMap.put((String)object, 1L);
                    }
                    catch (NumberFormatException l5) {
                        LOGGER.error("Error parsing measure", l5);
                    }
                    continue;
                }
                if (measure.getMetric().equals("alert_status")) {
                    String l6 = measure.getValue();
                    if (hashMap.containsKey(l6)) {
                        object = object2 = (Long)hashMap.get(l6);
                        object2 = (Long)object2 + 1L;
                        l3 = object2;
                        hashMap.put(l6, (Long)object2);
                        continue;
                    }
                    hashMap.put(l6, 1L);
                    continue;
                }
                if (measure.getMetric().equals("ncloc")) {
                    Long l4 = (Long)hashMap.get(measure.getMetric());
                    object2 = Long.parseLong(measure.getValue());
                    l4 = l4 + (Long)object2;
                    hashMap.put(measure.getMetric(), l4);
                    object = FormatUtils.toSizeRating((Long)object2);
                    if (hashMap.containsKey(object)) {
                        l2 = l3 = (Long)hashMap.get(object);
                        l = l3 = Long.valueOf(l3 + 1L);
                        hashMap.put((String)object, l3);
                        continue;
                    }
                    hashMap.put((String)object, 1L);
                    continue;
                }
                Long l5 = hashMap.getOrDefault(measure.getMetric(), 0L);
                object2 = Long.parseLong(measure.getValue());
                l5 = l5 + (Long)object2;
                hashMap.put(measure.getMetric(), l5);
            }
        }
        Instant instant2 = Instant.now();
        long l = Duration.between(instant, instant2).toMillis() / 1000L;
        LOGGER.debug("Total measures retrieved {} ( Elapsed time: {} s )", (Object)hashMap.size(), (Object)l);
        return hashMap;
    }

    public Map<String, Map<String, Long>> getProjectMeasures(List<String> list, List<String> list2) {
        Object object;
        Instant instant = Instant.now();
        LOGGER.debug("Getting project measures for {} projects", (Object)list.size());
        HashMap<String, Map<String, Long>> hashMap = new HashMap<String, Map<String, Long>>();
        for (String object22 : list) {
            object = new HashMap();
            for (String string : list2) {
                if (string.equals("alert_status")) {
                    object.put(string, 2L);
                    continue;
                }
                object.put(string, 0L);
            }
            hashMap.put(object22, (Map<String, Long>)object);
        }
        List<List<String>> list3 = Lists.partition(list, 100);
        Iterator iterator2 = list3.iterator();
        while (iterator2.hasNext()) {
            object = (List)iterator2.next();
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.setMetricKeys(list2);
            searchRequest.setProjectKeys((List<String>)object);
            Measures.SearchWsResponse searchWsResponse = this.wsClient.measures().search(searchRequest);
            for (Measures.Measure measure : searchWsResponse.getMeasuresList()) {
                Object object2;
                LOGGER.debug("Project: {} ... Key: {} ... Value: {}", measure.getComponent(), measure.getMetric(), measure.getValue());
                Map map = (Map)hashMap.get(measure.getComponent());
                if (measure.getMetric().equals("ncloc_language_distribution")) {
                    object2 = KeyValueFormat.parse(measure.getValue());
                    for (String string : object2.keySet()) {
                        Long l = Long.parseLong((String)object2.get(string));
                        if (map.containsKey(string)) {
                            Long l2 = (Long)map.get(string);
                            l2 = l2 + l;
                            map.put(string, l2);
                            continue;
                        }
                        map.put(string, l);
                    }
                    continue;
                }
                if (measure.getMetric().equals("reliability_rating") || measure.getMetric().equals("security_rating") || measure.getMetric().equals("sqale_rating") || measure.getMetric().equals("security_review_rating")) {
                    object2 = (long)Double.parseDouble(measure.getValue());
                    map.put(measure.getMetric(), object2);
                    continue;
                }
                if (measure.getMetric().equals("alert_status")) {
                    object2 = 0L;
                    if (measure.getValue().equals(STATUS_OK)) {
                        object2 = 1L;
                    } else if (measure.getValue().equals(STATUS_NONE)) {
                        object2 = 2L;
                    }
                    map.put(measure.getMetric(), object2);
                    continue;
                }
                try {
                    object2 = Long.parseLong(measure.getValue());
                    map.put(measure.getMetric(), object2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn("Metric {} type for project {} is not a long value, unable to sumarize it!", (Object)measure.getMetric(), (Object)measure.getComponent());
                }
            }
        }
        Instant instant2 = Instant.now();
        long l = Duration.between(instant, instant2).toMillis() / 1000L;
        LOGGER.debug("Total measures retrieved {} ( Elapsed time: {} s )", (Object)hashMap.size(), (Object)l);
        return hashMap;
    }

    public Common.Facets getFacets() {
        ArrayList<String> arrayList = new ArrayList<String>(OVERVIEW_FACETS);
        if (!this.isSonarQube7X()) {
            arrayList.add("security_review_rating");
        }
        SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
        searchProjectsRequest.setFacets(arrayList);
        if (!SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) && !this.isSonarQubePrevious8x3()) {
            searchProjectsRequest.setFilter(FILTER_TRK_QUALIFIER);
        }
        Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
        return searchProjectsWsResponse.getFacets();
    }

    public Map<String, Long> getFacetDistribution(Common.Facets facets, String string) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Common.Facet facet : facets.getFacetsList()) {
            if (!facet.getProperty().equals(string)) continue;
            for (int i = 0; i < facet.getValuesList().size(); ++i) {
                hashMap.put(facet.getValues(i).getVal(), facet.getValues(i).getCount());
            }
        }
        return hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, l2) -> l, LinkedHashMap::new));
    }

    public Map<String, Long> getSizeRatingDistribution(Common.Facets facets) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Common.Facet facet : facets.getFacetsList()) {
            if (!facet.getProperty().equals("ncloc")) continue;
            hashMap.put("XS", facet.getValues(0).getCount());
            hashMap.put("S", facet.getValues(1).getCount());
            hashMap.put("M", facet.getValues(2).getCount());
            hashMap.put("L", facet.getValues(3).getCount());
            hashMap.put("XL", facet.getValues(4).getCount());
        }
        return hashMap;
    }

    public Map<String, Long> getRatingDistribution(Common.Facets facets, String string) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Common.Facet facet : facets.getFacetsList()) {
            if (facet.getProperty().equals(string) && !string.equals("coverage")) {
                hashMap.put("A", facet.getValues(0).getCount());
                hashMap.put("B", facet.getValues(1).getCount());
                hashMap.put("C", facet.getValues(2).getCount());
                hashMap.put("D", facet.getValues(3).getCount());
                hashMap.put("E", facet.getValues(4).getCount());
                continue;
            }
            if (!facet.getProperty().equals(string) || !facet.getProperty().equals("coverage")) continue;
            hashMap.put(MAP_NO_DATA, facet.getValues(0).getCount());
            hashMap.put("E", facet.getValues(1).getCount());
            hashMap.put("D", facet.getValues(2).getCount());
            hashMap.put("C", facet.getValues(3).getCount());
            hashMap.put("B", facet.getValues(4).getCount());
            hashMap.put("A", facet.getValues(5).getCount());
        }
        return hashMap;
    }

    public Integer getTotalNumberOfProjects() {
        ArrayList<String> arrayList = new ArrayList<String>(OVERVIEW_FACETS);
        if (!this.isSonarQube7X()) {
            arrayList.add("security_review_rating");
        }
        SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
        searchProjectsRequest.setFacets(arrayList);
        if (!SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) && !this.isSonarQubePrevious8x3()) {
            searchProjectsRequest.setFilter(FILTER_TRK_QUALIFIER);
        }
        Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
        return searchProjectsWsResponse.getPaging().getTotal();
    }

    public List<String> getProjectTags() {
        org.sonarqube.ws.client.projecttags.SearchRequest searchRequest = new org.sonarqube.ws.client.projecttags.SearchRequest();
        searchRequest.setPs("100");
        ProjectTags.SearchResponse searchResponse = this.wsClient.projectTags().search(searchRequest);
        LOGGER.debug("Total project tags retrieved: {}", (Object)searchResponse.getTagsCount());
        return searchResponse.getTagsList();
    }

    public List<String> getProjectKeysForTag(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
        searchProjectsRequest.setFilter(String.format("tags=%s", string));
        searchProjectsRequest.setPs("500");
        Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
        for (Components.Component serializable : searchProjectsWsResponse.getComponentsList()) {
            if (!SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) && !this.isSonarQubePrevious8x3() && !serializable.getQualifier().equals("TRK") || !serializable.getTags().getTagsList().contains(string)) continue;
            arrayList.add(serializable.getKey());
        }
        if (searchProjectsWsResponse.hasPaging()) {
            Integer n = searchProjectsWsResponse.getPaging().getTotal();
            LOGGER.debug(DEBUG_TOTAL_PROJECTS_MESSAGE, (Object)n);
            LOGGER.debug(DEBUG_PAGE_SIZE_500_MESSAGE);
            Double d2 = Math.ceil((double)n.intValue() / 500.0);
            LOGGER.debug(DEBUG_TOTAL_PAGES_MESSAGE, (Object)d2);
            int n2 = 2;
            while ((double)n2 <= d2) {
                LOGGER.debug(DEBUG_REQUESTING_PAGE, (Object)n2, (Object)d2);
                searchProjectsRequest = new SearchProjectsRequest();
                searchProjectsRequest.setPs("500");
                searchProjectsRequest.setP(Integer.toString(n2));
                searchProjectsRequest.setFilter(String.format("tags=%s", string));
                searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                    if (!SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) && !this.isSonarQubePrevious8x3() && !component.getQualifier().equals("TRK") || !component.getTags().getTagsList().contains(string) || arrayList.contains(component.getKey())) continue;
                    arrayList.add(component.getKey());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public String computeGlobalRating(Map<String, Long> map) {
        map.putIfAbsent("A", 0L);
        map.putIfAbsent("B", 0L);
        map.putIfAbsent("C", 0L);
        map.putIfAbsent("D", 0L);
        map.putIfAbsent("E", 0L);
        Long l = map.get("E") * 5L + map.get("D") * 4L + map.get("C") * 3L + map.get("B") * 2L + map.get("A");
        Long l2 = map.get("E") + map.get("D") + map.get("C") + map.get("B") + map.get("A");
        Long l3 = Math.round((double)l.longValue() / (double)l2.longValue());
        return FormatUtils.toRating(l3);
    }

    public String computeHealthRating(Map<String, Long> map) {
        Long l = map.get(STATUS_OK) == null ? 0L : map.get(STATUS_OK);
        Long l2 = map.get(STATUS_ERROR) == null ? 0L : map.get(STATUS_ERROR);
        Long l3 = l + l2;
        if (l3 != 0L) {
            Long l4 = l * 100L / (l + l2);
            return FormatUtils.toHealthRating(l4);
        }
        return "A";
    }

    public Map<String, Long> getIssuesCountBySeverity(List<String> list) {
        return this.getIssuesCountBySeverity(null, list);
    }

    public Map<String, Long> getIssuesCountBySeverity(String string, List<String> list) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        org.sonarqube.ws.client.issues.SearchRequest searchRequest = new org.sonarqube.ws.client.issues.SearchRequest();
        searchRequest.setFacets(Arrays.asList("severities"));
        searchRequest.setResolved(BOOLEAN_FALSE_STRING);
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        searchRequest.setComponentKeys(list);
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        hashMap.put("total", searchWsResponse.getTotal());
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return hashMap;
    }

    public Map<String, Long> getIssues(List<String> list) {
        return this.getIssuesForBranch(null, list);
    }

    public Map<String, Long> getIssuesForBranch(String string, List<String> list) {
        return this.getIssuesForBranch(string, list, null);
    }

    public Map<String, Long> getIssuesForBranch(String string, List<String> list, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        org.sonarqube.ws.client.issues.SearchRequest searchRequest = new org.sonarqube.ws.client.issues.SearchRequest();
        searchRequest.setFacets(Arrays.asList("rules"));
        searchRequest.setResolved(BOOLEAN_FALSE_STRING);
        if (string2 != null) {
            searchRequest.setSeverities(Arrays.asList(string2));
        }
        if (string != null) {
            searchRequest.setBranch(string);
        }
        searchRequest.setComponentKeys(list);
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return MapUtil.sortByValue(hashMap);
    }

    public Map<String, Long> getIssues(List<String> list, String string) {
        return this.getIssuesForBranch(null, list, string);
    }

    public Map<String, Object> generateIssuesDataForBranch(List<String> list, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Rules.Rule> hashMap2 = new HashMap<String, Rules.Rule>();
        SonarQubeRuleManager sonarQubeRuleManager = new SonarQubeRuleManager(this.wsClient);
        HashMap<String, Long> hashMap3 = new HashMap();
        HashMap<String, Long> hashMap4 = new HashMap();
        HashMap<String, Long> hashMap5 = new HashMap();
        HashMap<String, Long> hashMap6 = new HashMap();
        HashMap<String, Long> hashMap7 = new HashMap();
        HashMap<String, Long> hashMap8 = new HashMap();
        if (string == null) {
            hashMap3 = this.getIssues(list);
            hashMap4 = this.getIssues(list, SEVERITY_BLOCKER);
            hashMap5 = this.getIssues(list, SEVERITY_CRITICAL);
            hashMap6 = this.getIssues(list, SEVERITY_MAJOR);
            hashMap7 = this.getIssues(list, SEVERITY_MINOR);
            hashMap8 = this.getIssues(list, SEVERITY_INFO);
        } else {
            for (String string2 : list) {
                Map<String, Long> map2 = this.getIssuesForBranch(string, Arrays.asList(string2));
                for (Map.Entry<String, Long> entry : map2.entrySet()) {
                    Long l = hashMap3.getOrDefault(entry.getKey(), 0L);
                    hashMap3.put(entry.getKey(), l + entry.getValue());
                }
                Map<String, Long> map4 = this.getIssuesForBranch(string, Arrays.asList(string2), SEVERITY_BLOCKER);
                for (Map.Entry entry : map4.entrySet()) {
                    Long l = hashMap4.getOrDefault(entry.getKey(), 0L);
                    hashMap4.put((String)entry.getKey(), l + (Long)entry.getValue());
                }
                Map<String, Long> map3 = this.getIssuesForBranch(string, Arrays.asList(string2), SEVERITY_CRITICAL);
                for (Map.Entry<String, Long> entry : map3.entrySet()) {
                    Long l = hashMap5.getOrDefault(entry.getKey(), 0L);
                    hashMap5.put(entry.getKey(), l + entry.getValue());
                }
                Map<String, Long> map = this.getIssuesForBranch(string, Arrays.asList(string2), SEVERITY_MAJOR);
                for (Map.Entry<String, Long> entry : map.entrySet()) {
                    Long l = hashMap6.getOrDefault(entry.getKey(), 0L);
                    hashMap6.put(entry.getKey(), l + entry.getValue());
                }
                Map<String, Long> map5 = this.getIssuesForBranch(string, Arrays.asList(string2), SEVERITY_MINOR);
                for (Map.Entry<String, Long> entry : map5.entrySet()) {
                    Object object = hashMap7.getOrDefault(entry.getKey(), 0L);
                    hashMap7.put(entry.getKey(), (Long)object + entry.getValue());
                }
                Map<String, Long> map6 = this.getIssuesForBranch(string, Arrays.asList(string2), SEVERITY_INFO);
                for (Object object : map6.entrySet()) {
                    Long l = hashMap8.getOrDefault(object.getKey(), 0L);
                    hashMap8.put((String)object.getKey(), l + (Long)object.getValue());
                }
            }
        }
        this.fillRules(hashMap2, sonarQubeRuleManager, hashMap3);
        this.fillRules(hashMap2, sonarQubeRuleManager, hashMap4, SEVERITY_BLOCKER);
        this.fillRules(hashMap2, sonarQubeRuleManager, hashMap5, SEVERITY_CRITICAL);
        this.fillRules(hashMap2, sonarQubeRuleManager, hashMap6, SEVERITY_MAJOR);
        this.fillRules(hashMap2, sonarQubeRuleManager, hashMap7, SEVERITY_MINOR);
        this.fillRules(hashMap2, sonarQubeRuleManager, hashMap8, SEVERITY_INFO);
        hashMap.put("rulesKeys", hashMap2.keySet());
        hashMap.put("rulesCount", MapUtil.sortByValue(hashMap3));
        hashMap.put("blockerRulesCount", MapUtil.sortByValue(hashMap4));
        hashMap.put("criticalRulesCount", MapUtil.sortByValue(hashMap5));
        hashMap.put("majorRulesCount", MapUtil.sortByValue(hashMap6));
        hashMap.put("minorRulesCount", MapUtil.sortByValue(hashMap7));
        hashMap.put("infoRulesCount", MapUtil.sortByValue(hashMap8));
        hashMap.put("rulesObjects", hashMap2);
        return hashMap;
    }

    public Map<String, Object> generateIssuesData(List<String> list) {
        return this.generateIssuesDataForBranch(list, null);
    }

    public Map<String, Object> generateIssuesData() {
        return this.generateIssuesDataForBranch(this.getAllProjectKeys(), null);
    }

    public Map<String, Object> generateIssuesData(String string) {
        return this.generateIssuesDataForBranch(this.getAllProjectKeys(), string);
    }

    public Map<String, Object> generateIssuesData(List<String> list, String string) {
        return this.generateIssuesDataForBranch(list, string);
    }

    private void fillRules(Map<String, Rules.Rule> map, SonarQubeRuleManager sonarQubeRuleManager, Map<String, Long> map2, String string) {
        for (Map.Entry<String, Long> entry : map2.entrySet()) {
            try {
                Rules.Rule rule = sonarQubeRuleManager.getRule(entry.getKey());
                if (Rules.Rule.getDefaultInstance() != rule) {
                    LOGGER.debug(DEBUG_ISSUE_COUNT_PER_RULE_MESSAGE, (Object)entry.getValue(), (Object)rule.getName());
                    if (map.containsKey(entry.getKey())) continue;
                    map.put(entry.getKey(), rule);
                    continue;
                }
                if (string != null) {
                    map.put(entry.getKey(), Rules.Rule.newBuilder().setName(entry.getKey()).setSeverity(string).build());
                    continue;
                }
                map.put(entry.getKey(), Rules.Rule.newBuilder().setName(entry.getKey()).build());
            }
            catch (SonarQubeException sonarQubeException) {
                LOGGER.warn(DEBUG_UNABLE_TO_GET_RULE, (Object)entry.getKey(), (Object)sonarQubeException.getMessage());
            }
        }
    }

    private void fillRules(Map<String, Rules.Rule> map, SonarQubeRuleManager sonarQubeRuleManager, Map<String, Long> map2) {
        this.fillRules(map, sonarQubeRuleManager, map2, null);
    }

    private Map<String, Object> generateMeasureDataForMainBranch(List<String> list, boolean bl) {
        Map.Entry<String, Long> entry2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Integer n = list.size();
        hashMap.put(MAP_TOTAL_PROJECTS, n);
        Common.Facets facets = this.getFacets();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ncloc");
        arrayList.add("bugs");
        arrayList.add("vulnerabilities");
        arrayList.add("code_smells");
        arrayList.add("duplicated_lines");
        arrayList.add("ncloc_language_distribution");
        arrayList.add("lines");
        arrayList.add("conditions_to_cover");
        arrayList.add("uncovered_conditions");
        arrayList.add("lines_to_cover");
        arrayList.add("uncovered_lines");
        arrayList.add("security_hotspots");
        if (bl) {
            arrayList.add("reliability_rating");
            arrayList.add("security_rating");
            arrayList.add("security_review_rating");
            arrayList.add("sqale_rating");
            arrayList.add("alert_status");
            arrayList.add("duplicated_lines_density");
            arrayList.add("coverage");
        }
        Map<String, Long> map = this.getTotalMeasures(list, arrayList);
        Map<String, String> map2 = FormatUtils.formatLongMeasuresMap(map, this.userLocale);
        hashMap.put(MAP_MEASURES, map);
        hashMap.put(MAP_LOCALE_MEASURES, map2);
        Map<String, Long> map3 = this.getFacetDistribution(facets, FACET_LANGUAGES);
        HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry2 : map3.entrySet()) {
            if (!map.containsKey(entry2.getKey())) continue;
            hashMap2.put(entry2.getKey(), map.get(entry2.getKey()));
        }
        hashMap.put(FACET_LANGUAGES, FormatUtils.formatLongMeasuresMap(MapUtil.sortByValue(hashMap2), this.userLocale));
        Map<String, Long> map4 = this.getSizeRatingDistribution(facets);
        hashMap.put(MAP_SIZE_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map4, this.userLocale));
        entry2 = this.getRatingDistribution(facets, "reliability_rating");
        hashMap.put(MAP_RELIABILITY_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap((Map<String, Long>)((Object)entry2), this.userLocale));
        String string = this.computeGlobalRating((Map<String, Long>)((Object)entry2));
        hashMap.put(MAP_RELIABILITY_RATING, string);
        Map<String, Long> map5 = this.getRatingDistribution(facets, "security_rating");
        hashMap.put(MAP_SECURITY_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map5, this.userLocale));
        String string2 = this.computeGlobalRating(map5);
        hashMap.put(MAP_SECURITY_RATING, string2);
        Map<String, Long> map6 = this.getRatingDistribution(facets, "sqale_rating");
        hashMap.put(MAP_MAINTAINABILITY_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map6, this.userLocale));
        String string3 = this.computeGlobalRating(map6);
        hashMap.put(MAP_MAINTAINABILITY_RATING, string3);
        Map<String, Long> map7 = this.getRatingDistribution(facets, "security_review_rating");
        hashMap.put(MAP_SECURITY_REVIEW_RATING_DISTRIBUTION, map7);
        String string4 = this.computeGlobalRating(map7);
        hashMap.put(MAP_SECURITY_REVIEW_RATING, string4);
        Map<String, Long> map8 = this.getFacetDistribution(facets, "alert_status");
        hashMap.put(MAP_HEALTH_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map8, this.userLocale));
        Long l = map8.get(STATUS_OK) + map8.get(STATUS_ERROR);
        hashMap.put("healthValueOK", n != 0 && l != 0L ? map8.get(STATUS_OK) * 100L / l : 0L);
        hashMap.put("healthValueERROR", n != 0 && l != 0L ? map8.get(STATUS_ERROR) * 100L / l : 0L);
        String string5 = this.computeHealthRating(map8);
        hashMap.put(MAP_HEALTH_RATING, string5);
        Double d2 = (double)(map.get("conditions_to_cover") - map.get("uncovered_conditions") + map.get("lines_to_cover") - map.get("uncovered_lines")) / (double)(map.get("conditions_to_cover") + map.get("lines_to_cover"));
        hashMap.put("coverage", d2);
        map2.put("coverage", FormatUtils.getPercentage(this.userLocale).format(d2));
        hashMap.put(MAP_COVERAGE_PERCENT, d2 * 100.0);
        hashMap.put(MAP_UNCOVERED_PERCENT, (1.0 - d2) * 100.0);
        Map<String, Long> map9 = this.getRatingDistribution(facets, "coverage");
        hashMap.put(MAP_COVERAGE_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map9, this.userLocale));
        Double d3 = (double)map.get("duplicated_lines").longValue() / (double)map.get("lines").longValue();
        hashMap.put(MAP_DUPLICATIONS, d3);
        map2.put("duplicated_lines_density", FormatUtils.getPercentage(this.userLocale).format(d3));
        String string6 = FormatUtils.toDuplicationsRating(d3 * 100.0);
        hashMap.put(MAP_DUPLICATIONS_RATING, string6);
        Map<String, Long> map10 = this.getRatingDistribution(facets, "duplicated_lines_density");
        hashMap.put(MAP_DUPLICATIONS_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map10, this.userLocale));
        Map<String, Long> map11 = this.getIssuesCountBySeverity(list);
        hashMap.put(MAP_ISSUES, FormatUtils.formatLongMeasuresMap(map11, this.userLocale));
        String string7 = FormatUtils.toSizeRating(map.get("ncloc"));
        hashMap.put(MAP_SIZE_RATING, string7);
        if (bl) {
            LOGGER.debug("Computing ratings for {} projects", (Object)n);
            Map<String, String> map12 = this.generateRatingDistributionFromMeasureData("reliability_rating", map);
            Long l2 = this.getTotalProjectsFromRatingDistributionFromMeasureData("reliability_rating", map);
            LOGGER.debug("                      {} projects with rating", (Object)l2);
            Long l3 = 0L;
            Long l4 = 0L;
            Long l5 = 0L;
            Long l6 = 0L;
            if (l2 > 0L) {
                l3 = Math.round((double)map.get("reliability_rating").longValue() / (double)l2.longValue());
                l4 = Math.round((double)map.get("security_rating").longValue() / (double)l2.longValue());
                l5 = Math.round((double)map.get("security_review_rating").longValue() / (double)l2.longValue());
                l6 = Math.round((double)map.get("sqale_rating").longValue() / (double)l2.longValue());
            }
            string = FormatUtils.toRating(l3);
            string2 = FormatUtils.toRating(l4);
            string4 = FormatUtils.toRating(l5);
            string3 = FormatUtils.toRating(l6);
            hashMap.put(MAP_RELIABILITY_RATING, string);
            hashMap.put(MAP_RELIABILITY_RATING_DISTRIBUTION, map12);
            hashMap.put(MAP_SECURITY_RATING, string2);
            hashMap.put(MAP_SECURITY_RATING_DISTRIBUTION, this.generateRatingDistributionFromMeasureData("security_rating", map));
            hashMap.put(MAP_SECURITY_REVIEW_RATING, string4);
            hashMap.put(MAP_SECURITY_REVIEW_RATING_DISTRIBUTION, this.generateRatingDistributionFromMeasureData("security_review_rating", map));
            hashMap.put(MAP_MAINTAINABILITY_RATING, string3);
            hashMap.put(MAP_MAINTAINABILITY_RATING_DISTRIBUTION, this.generateRatingDistributionFromMeasureData("sqale_rating", map));
            hashMap.put(MAP_DUPLICATIONS_RATING_DISTRIBUTION, this.generateRatingDistributionFromMeasureData("duplications_rating", map));
            hashMap.put(MAP_COVERAGE_RATING_DISTRIBUTION, this.generateRatingDistributionFromMeasureData("coverage_rating", map));
            hashMap.put(MAP_SIZE_RATING_DISTRIBUTION, this.generateRatingDistributionFromMeasureData("ncloc", map));
        }
        return hashMap;
    }

    private Map<String, String> generateRatingDistributionFromMeasureData(String string, Map<String, Long> map) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if ("ncloc".equals(string)) {
            hashMap.put("XL", this.getValueForMetricInMeasureData("XL", map));
            hashMap.put("L", this.getValueForMetricInMeasureData("L", map));
            hashMap.put("M", this.getValueForMetricInMeasureData("M", map));
            hashMap.put("S", this.getValueForMetricInMeasureData("S", map));
            hashMap.put("XS", this.getValueForMetricInMeasureData("XS", map));
        } else {
            hashMap.put("A", this.getValueForMetricInMeasureData(string + "_A", map));
            hashMap.put("B", this.getValueForMetricInMeasureData(string + "_B", map));
            hashMap.put("C", this.getValueForMetricInMeasureData(string + "_C", map));
            hashMap.put("D", this.getValueForMetricInMeasureData(string + "_D", map));
            hashMap.put("E", this.getValueForMetricInMeasureData(string + "_E", map));
            if ("coverage_rating".equals(string)) {
                hashMap.put(MAP_NO_DATA, this.getValueForMetricInMeasureData(string + MAP_NO_DATA_SUFFIX, map));
            }
        }
        return FormatUtils.formatLongMeasuresMap(hashMap, this.userLocale);
    }

    private Long getValueForMetricInMeasureData(String string, Map<String, Long> map) {
        return map.get(string) != null ? map.get(string) : 0L;
    }

    private long getTotalProjectsFromRatingDistributionFromMeasureData(String string, Map<String, Long> map) {
        long l = 0L;
        if ("ncloc".equals(string)) {
            l += this.getValueForMetricInMeasureData("XL", map).longValue();
            l += this.getValueForMetricInMeasureData("L", map).longValue();
            l += this.getValueForMetricInMeasureData("M", map).longValue();
            l += this.getValueForMetricInMeasureData("S", map).longValue();
            l += this.getValueForMetricInMeasureData("XS", map).longValue();
        } else {
            l += this.getValueForMetricInMeasureData(string + "_A", map).longValue();
            l += this.getValueForMetricInMeasureData(string + "_B", map).longValue();
            l += this.getValueForMetricInMeasureData(string + "_C", map).longValue();
            l += this.getValueForMetricInMeasureData(string + "_D", map).longValue();
            l += this.getValueForMetricInMeasureData(string + "_E", map).longValue();
            if ("coverage_rating".equals(string)) {
                l += this.getValueForMetricInMeasureData(string + MAP_NO_DATA_SUFFIX, map).longValue();
            }
        }
        return l;
    }

    public Map<String, Object> generateMeasureDataForMainBranch(List<String> list) {
        return this.generateMeasureDataForMainBranch(list, false);
    }

    public Map<String, Object> generatePortfolioMeasureDataForMainBranch(List<String> list) {
        return this.generateMeasureDataForMainBranch(list, true);
    }

    public Map<String, Object> generateMeasureDataForBranch(List<String> list, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<String, List<Measures.Measure>> map = this.getMeasureListPerProject(this.wsClient, list, string);
        Map<String, Long> map2 = this.getLanguageLinesDistribution(map);
        hashMap.put(FACET_LANGUAGES, FormatUtils.formatLongMeasuresMap(map2, this.userLocale));
        Map<String, Long> map3 = this.getSizeRatingDistribution(map);
        hashMap.put(MAP_SIZE_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map3, this.userLocale));
        Integer n = map.size();
        hashMap.put(MAP_TOTAL_PROJECTS, n);
        Map<String, Long> map4 = this.getRatingDistribution(map, "reliability_rating");
        hashMap.put(MAP_RELIABILITY_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map4, this.userLocale));
        String string2 = this.computeGlobalRating(map4);
        hashMap.put(MAP_RELIABILITY_RATING, string2);
        Map<String, Long> map5 = this.getRatingDistribution(map, "security_rating");
        hashMap.put(MAP_SECURITY_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map5, this.userLocale));
        String string3 = this.computeGlobalRating(map5);
        hashMap.put(MAP_SECURITY_RATING, string3);
        Map<String, Long> map6 = this.getRatingDistribution(map, "security_review_rating");
        hashMap.put(MAP_SECURITY_REVIEW_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map6, this.userLocale));
        String string4 = this.computeGlobalRating(map6);
        hashMap.put(MAP_SECURITY_REVIEW_RATING, string4);
        Map<String, Long> map7 = this.getRatingDistribution(map, "sqale_rating");
        hashMap.put(MAP_MAINTAINABILITY_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map7, this.userLocale));
        String string5 = this.computeGlobalRating(map7);
        hashMap.put(MAP_MAINTAINABILITY_RATING, string5);
        Map<String, Long> map8 = this.getQualityGateStatusDistribution(map);
        hashMap.put(MAP_HEALTH_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map8, this.userLocale));
        Long l = map8.get(STATUS_OK) + map8.get(STATUS_ERROR);
        hashMap.put("healthValueOK", n != 0 && l != 0L ? map8.get(STATUS_OK) * 100L / l : 0L);
        hashMap.put("healthValueERROR", n != 0 && l != 0L ? map8.get(STATUS_ERROR) * 100L / l : 0L);
        String string6 = this.computeHealthRating(map8);
        hashMap.put(MAP_HEALTH_RATING, string6);
        Map<String, Long> map9 = this.getTotalMeasures(map, Arrays.asList("ncloc", "bugs", "vulnerabilities", "code_smells", "security_hotspots", "duplicated_lines", "lines", "conditions_to_cover", "uncovered_conditions", "lines_to_cover", "uncovered_lines"));
        Map<String, String> map10 = FormatUtils.formatLongMeasuresMap(map9, this.userLocale);
        for (Map.Entry<String, Long> object2 : map2.entrySet()) {
            map9.put(object2.getKey(), object2.getValue());
        }
        hashMap.put(MAP_MEASURES, map9);
        hashMap.put(MAP_LOCALE_MEASURES, map10);
        Double d2 = (double)(map9.get("conditions_to_cover") - map9.get("uncovered_conditions") + map9.get("lines_to_cover") - map9.get("uncovered_lines")) / (double)(map9.get("conditions_to_cover") + map9.get("lines_to_cover"));
        hashMap.put("coverage", d2);
        map10.put("coverage", FormatUtils.getPercentage(this.userLocale).format(d2));
        hashMap.put(MAP_COVERAGE_PERCENT, d2 * 100.0);
        hashMap.put(MAP_UNCOVERED_PERCENT, (1.0 - d2) * 100.0);
        Map<String, Long> map11 = this.getCoverageRatingDistribution(map);
        hashMap.put(MAP_COVERAGE_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map11, this.userLocale));
        Double d3 = (double)map9.get("duplicated_lines").longValue() / (double)map9.get("lines").longValue();
        hashMap.put(MAP_DUPLICATIONS, d3);
        map10.put("duplicated_lines_density", FormatUtils.getPercentage(this.userLocale).format(d3));
        String string7 = FormatUtils.toDuplicationsRating(d3 * 100.0);
        hashMap.put(MAP_DUPLICATIONS_RATING, string7);
        Map<String, Long> map12 = this.getDuplicationsRatingDistribution(map);
        hashMap.put(MAP_DUPLICATIONS_RATING_DISTRIBUTION, FormatUtils.formatLongMeasuresMap(map12, this.userLocale));
        Map<String, Long> map13 = this.getIssuesCountBySeverity(string, list);
        if (string != null) {
            map13 = new HashMap<String, Long>();
            for (String string8 : list) {
                Map<String, Long> map14 = this.getIssuesCountBySeverity(string, Arrays.asList(string8));
                for (Map.Entry<String, Long> entry : map14.entrySet()) {
                    Long l2 = map13.getOrDefault(entry.getKey(), 0L);
                    map13.put(entry.getKey(), l2 + entry.getValue());
                }
            }
        }
        hashMap.put(MAP_ISSUES, FormatUtils.formatLongMeasuresMap(map13, this.userLocale));
        String string9 = FormatUtils.toSizeRating(map9.get("ncloc"));
        hashMap.put(MAP_SIZE_RATING, string9);
        return hashMap;
    }

    private Map<String, Long> getLanguageLinesDistribution(Map<String, List<Measures.Measure>> map) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (List<Measures.Measure> list : map.values()) {
            for (Measures.Measure measure : list) {
                if (!"ncloc_language_distribution".equals(measure.getMetric())) continue;
                String string = measure.getValue();
                for (Map.Entry<String, String> entry : KeyValueFormat.parse(string).entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) {
                        Long l = (Long)hashMap.get(entry.getKey());
                        hashMap.put(entry.getKey(), l + Long.parseLong(entry.getValue()));
                        continue;
                    }
                    hashMap.put(entry.getKey(), Long.parseLong(entry.getValue()));
                }
            }
        }
        return hashMap;
    }

    private Map<String, Long> getSizeRatingDistribution(Map<String, List<Measures.Measure>> map) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("XL", 0L);
        hashMap.put("L", 0L);
        hashMap.put("M", 0L);
        hashMap.put("S", 0L);
        hashMap.put("XS", 0L);
        for (List<Measures.Measure> list : map.values()) {
            for (Measures.Measure measure : list) {
                if (!"ncloc".equals(measure.getMetric())) continue;
                String string = FormatUtils.toSizeRating(Long.parseLong(measure.getValue()));
                if (hashMap.containsKey(string)) {
                    Long l = (Long)hashMap.get(string);
                    hashMap.put(string, l + 1L);
                    continue;
                }
                hashMap.put(string, 1L);
            }
        }
        return hashMap;
    }

    private Map<String, Long> getCoverageRatingDistribution(Map<String, List<Measures.Measure>> map) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("A", 0L);
        hashMap.put("B", 0L);
        hashMap.put("C", 0L);
        hashMap.put("D", 0L);
        hashMap.put("E", 0L);
        hashMap.put(MAP_NO_DATA, 0L);
        for (List<Measures.Measure> list : map.values()) {
            for (Measures.Measure measure : list) {
                if (!"coverage".equals(measure.getMetric())) continue;
                String string = FormatUtils.toCoverageRating(Double.parseDouble(measure.getValue()));
                if (hashMap.containsKey(string)) {
                    Long l;
                    Long l2 = l = (Long)hashMap.get(string);
                    Long l3 = l = Long.valueOf(l + 1L);
                    hashMap.put(string, l);
                    continue;
                }
                hashMap.put(string, 1L);
            }
        }
        return hashMap;
    }

    private Map<String, Long> getDuplicationsRatingDistribution(Map<String, List<Measures.Measure>> map) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("A", 0L);
        hashMap.put("B", 0L);
        hashMap.put("C", 0L);
        hashMap.put("D", 0L);
        hashMap.put("E", 0L);
        for (List<Measures.Measure> list : map.values()) {
            for (Measures.Measure measure : list) {
                if (!"duplicated_lines_density".equals(measure.getMetric())) continue;
                double d2 = Double.parseDouble(measure.getValue());
                String string = FormatUtils.toDuplicationsRating(d2);
                if (hashMap.containsKey(string)) {
                    Long l;
                    Long l2 = l = (Long)hashMap.get(string);
                    Long l3 = l = Long.valueOf(l + 1L);
                    hashMap.put(string, l);
                    continue;
                }
                hashMap.put(string, 1L);
            }
        }
        return hashMap;
    }

    private Map<String, Long> getRatingDistribution(Map<String, List<Measures.Measure>> map, String string) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("A", 0L);
        hashMap.put("B", 0L);
        hashMap.put("C", 0L);
        hashMap.put("D", 0L);
        hashMap.put("E", 0L);
        for (List<Measures.Measure> list : map.values()) {
            for (Measures.Measure measure : list) {
                if (!string.equals(measure.getMetric())) continue;
                Long l = (long)Double.parseDouble(measure.getValue());
                String string2 = FormatUtils.toRating(l);
                if (hashMap.containsKey(string2)) {
                    Long l2 = (Long)hashMap.get(string2);
                    hashMap.put(string2, l2 + 1L);
                    continue;
                }
                hashMap.put(string2, 1L);
            }
        }
        return hashMap;
    }

    private Map<String, Long> getQualityGateStatusDistribution(Map<String, List<Measures.Measure>> map) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(STATUS_OK, 0L);
        hashMap.put(STATUS_ERROR, 0L);
        for (List<Measures.Measure> list : map.values()) {
            for (Measures.Measure measure : list) {
                if (!"alert_status".equals(measure.getMetric())) continue;
                String string = measure.getValue();
                if (hashMap.containsKey(string)) {
                    Long l = (Long)hashMap.get(string);
                    hashMap.put(string, l + 1L);
                    continue;
                }
                hashMap.put(string, 1L);
            }
        }
        return hashMap;
    }

    private Map<String, Long> getTotalMeasures(Map<String, List<Measures.Measure>> map, List<String> list) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (String object : list) {
            hashMap.put(object, 0L);
        }
        for (List list2 : map.values()) {
            for (Measures.Measure measure : list2) {
                if (!list.contains(measure.getMetric())) continue;
                Long l = Long.parseLong(measure.getValue());
                Long l2 = (Long)hashMap.get(measure.getMetric());
                hashMap.put(measure.getMetric(), l2 + l);
            }
        }
        return hashMap;
    }

    private Map<String, List<Measures.Measure>> getMeasureListPerProject(WsClient wsClient, List<String> list, String string) {
        HashMap<String, List<Measures.Measure>> hashMap = new HashMap<String, List<Measures.Measure>>();
        for (String string2 : list) {
            LOGGER.debug("Getting measures for project {}", (Object)string2);
            try {
                ComponentRequest componentRequest = new ComponentRequest();
                componentRequest.setMetricKeys(Arrays.asList("reliability_rating", "security_rating", "security_review_rating", "sqale_rating", "ncloc_language_distribution", "ncloc", "bugs", "vulnerabilities", "code_smells", "security_hotspots", "duplicated_lines", "duplicated_lines_density", "lines", "conditions_to_cover", "coverage", "uncovered_conditions", "lines_to_cover", "uncovered_lines", "alert_status"));
                componentRequest.setComponent(string2);
                if (string != null && !string.isEmpty()) {
                    componentRequest.setBranch(string);
                }
                Measures.ComponentWsResponse componentWsResponse = wsClient.measures().component(componentRequest);
                List<Measures.Measure> list2 = componentWsResponse.getComponent().getMeasuresList();
                hashMap.put(string2, list2);
            }
            catch (HttpException httpException) {
                LOGGER.debug("Unable to get information from project {}", (Object)string2, (Object)httpException);
                LOGGER.warn("No data for project {} on branch {}", (Object)string2, (Object)string);
            }
        }
        return hashMap;
    }

    private boolean isSonarQube7X() {
        return this.serverVersion != null && this.serverVersion.startsWith("7.");
    }

    private boolean isSonarQubePrevious8x3() {
        int n = Integer.parseInt(this.serverVersion.substring(0, 1));
        int n2 = Integer.parseInt(this.serverVersion.substring(2, 3));
        return this.isSonarQube7X() || n == 8 && n2 <= 2;
    }
}

