/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.common.util.concurrent.AtomicDouble;
import es.sonarqube.api.Metric;
import es.sonarqube.api.SonarQubeHistoryMeasure;
import es.sonarqube.api.SonarQubeHistoryMetricValue;
import es.sonarqube.api.SonarQubeMeasure;
import es.sonarqube.api.SonarQubeMetric;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeMetricManager;
import es.sonarqube.managers.SonarQubeProjectManager;
import es.sonarqube.utils.FormatUtils;
import es.sonarqube.utils.ParamsUtils;
import es.sonarqube.utils.WorkDuration;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Measures;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.measures.ComponentRequest;
import org.sonarqube.ws.client.measures.SearchHistoryRequest;

public class SonarQubeMeasureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeMeasureManager.class);
    private final WsClient wsClient;
    private final Locale userLocale;
    private static final String VALUE = "_value";
    private static final String REST = "_rest";
    public static final String HISTORY_MEASURE_PAGE_SIZE_PARAM = "1000";

    public SonarQubeMeasureManager(WsClient wsClient, Locale locale) {
        this.wsClient = wsClient;
        this.userLocale = locale;
    }

    public SonarQubeMeasureManager(String string, String string2, Locale locale) {
        this.userLocale = locale;
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static List<SonarQubeMeasure> getMeasures(WsClient wsClient, String string, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeMeasureManager(wsClient, locale).getMeasures(string, list);
    }

    protected static List<SonarQubeMeasure> getMeasures(WsClient wsClient, List<String> list, List<String> list2, Locale locale) throws SonarQubeException {
        return new SonarQubeMeasureManager(wsClient, locale).getMeasures(list, list2);
    }

    protected static Map<String, Object> getAggregatedMeasures(WsClient wsClient, List<String> list, List<String> list2, Locale locale) throws SonarQubeException {
        return new SonarQubeMeasureManager(wsClient, locale).getAggregatedMeasures(list, list2);
    }

    public Map<String, String> getMeasuresMap(String string, String string2, List<String> list) throws SonarQubeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SonarQubeMeasure sonarQubeMeasure : this.getMeasures(Collections.singletonList(string), string2, list)) {
            LOGGER.debug("Measure {}", (Object)sonarQubeMeasure.getName());
            for (SonarQubeMetric sonarQubeMetric : sonarQubeMeasure.getSonarQubeMetricList()) {
                LOGGER.debug("{}: {}", (Object)sonarQubeMetric.getKey(), (Object)sonarQubeMetric.getValue());
                hashMap.put(sonarQubeMetric.getKey(), sonarQubeMetric.getValue());
            }
        }
        return hashMap;
    }

    public List<SonarQubeMeasure> getMeasures(String string, String string2, List<String> list) throws SonarQubeException {
        return this.getMeasures(Collections.singletonList(string), string2, list);
    }

    public List<SonarQubeMeasure> getMeasures(List<String> list, List<String> list2) throws SonarQubeException {
        return this.getMeasures(list, null, list2);
    }

    public Map<String, Object> getAggregatedMeasures(List<String> list, List<String> list2) throws SonarQubeException {
        return this.getAggregatedMeasures(list, list2, Collections.emptyList());
    }

    public Map<String, Object> getAggregatedMeasures(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getAggregatedMeasures(list, list2, Arrays.asList(string));
    }

    public Map<String, Object> getAggregatedMeasures(List<String> list, List<String> list2, List<String> list3) throws SonarQubeException {
        String string = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        try {
            AtomicDouble atomicDouble = new AtomicDouble(0.0);
            AtomicDouble atomicDouble2 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble3 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble4 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble5 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble6 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble7 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble8 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble9 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble10 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble11 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble12 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble13 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble14 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble15 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble16 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble17 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble18 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble19 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble20 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble21 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble22 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble23 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble24 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble25 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble26 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble27 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble28 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble29 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble30 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble31 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble32 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble33 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble34 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble35 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble36 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble37 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble38 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble39 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble40 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble41 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble42 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble43 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble44 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble45 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble46 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble47 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble48 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble49 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble50 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble51 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble52 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble53 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble54 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble55 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble56 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble57 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble58 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble59 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble60 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble61 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble62 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble63 = new AtomicDouble(0.0);
            Map<String, Integer> map = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map2 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map3 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map4 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map5 = this.createDistributionMap(Arrays.asList("XL", "L", "M", "S", "XS"), 0);
            Map<String, Integer> map6 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map7 = this.createDistributionMap(Arrays.asList("NO_DATA", "A", "B", "C", "D", "E"), 0);
            String string2 = "-period1";
            String string3 = "-period1";
            String string4 = "-diff";
            LOGGER.debug("Getting info for {} projects...", (Object)list.size());
            for (String string5 : list) {
                string5 = string5.trim();
                List<ProjectBranches.Branch> list4 = SonarQubeProjectManager.getProjectBranches(this.wsClient, string5, this.userLocale);
                boolean bl = true;
                for (String string6 : list3) {
                    if (list4 != null) {
                        for (ProjectBranches.Branch branch : list4) {
                            if (!branch.getName().equals(string6)) continue;
                            bl = false;
                            string = string6;
                            break;
                        }
                    }
                    if (bl) continue;
                    break;
                }
                List<SonarQubeMeasure> list5 = bl ? this.getMeasures(string5, null, list2) : this.getMeasures(string5, string, list2);
                list5.forEach(sonarQubeMeasure -> sonarQubeMeasure.getSonarQubeMetricList().forEach(sonarQubeMetric -> {
                    try {
                        if ("lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble2.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("ncloc".equals(sonarQubeMetric.getKey())) {
                            atomicDouble3.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble4.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("bugs".equals(sonarQubeMetric.getKey())) {
                            atomicDouble6.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("bugs" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble11.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_bugs" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble10.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("vulnerabilities".equals(sonarQubeMetric.getKey())) {
                            atomicDouble12.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("vulnerabilities" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble13.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_vulnerabilities" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble14.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("security_hotspots".equals(sonarQubeMetric.getKey())) {
                            atomicDouble15.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("security_hotspots" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble16.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_security_hotspots" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble17.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("code_smells".equals(sonarQubeMetric.getKey())) {
                            atomicDouble18.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("code_smells" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble19.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_code_smells" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble20.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("sqale_index".equals(sonarQubeMetric.getKey())) {
                            if (sonarQubeMetric.getValue().equals("0")) {
                                atomicDouble21.getAndAdd(WorkDuration.decode("0d", 8).toMinutes());
                            } else {
                                atomicDouble21.getAndAdd(WorkDuration.decode(sonarQubeMetric.getValue(), 8).toMinutes());
                            }
                        }
                        if ("new_technical_debt".equals(sonarQubeMetric.getKey())) {
                            if (sonarQubeMetric.getValue().equals("0")) {
                                atomicDouble48.getAndAdd(WorkDuration.decode("0d", 8).toMinutes());
                            } else {
                                atomicDouble48.getAndAdd(WorkDuration.decode(sonarQubeMetric.getValue(), 8).toMinutes());
                            }
                        }
                        if (("sqale_index" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble22.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("duplicated_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble5.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("duplicated_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble7.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("comment_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble8.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("comment_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble9.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("reliability_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble33.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map.putAll(this.processDistribution(map, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("security_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble34.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map2.putAll(this.processDistribution(map2, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("security_review_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble35.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map3.putAll(this.processDistribution(map3, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("sqale_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble36.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map4.putAll(this.processDistribution(map4, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("size_rating".equals(sonarQubeMetric.getKey())) {
                            map5.putAll(this.processDistribution(map5, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("duplicated_lines_rating".equals(sonarQubeMetric.getKey())) {
                            map6.putAll(this.processDistribution(map6, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("coverage_rating".equals(sonarQubeMetric.getKey())) {
                            map7.putAll(this.processDistribution(map7, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("conditions_to_cover".equals(sonarQubeMetric.getKey())) {
                            atomicDouble26.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("uncovered_conditions".equals(sonarQubeMetric.getKey())) {
                            atomicDouble25.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("lines_to_cover".equals(sonarQubeMetric.getKey())) {
                            atomicDouble27.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("uncovered_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble28.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_conditions_to_cover" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble30.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_uncovered_conditions" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble29.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_lines_to_cover" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble31.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_uncovered_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble32.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("complexity".equals(sonarQubeMetric.getKey())) {
                            atomicDouble37.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble38.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("blocker_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble39.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_blocker_violations" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble40.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("critical_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble41.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_critical_violations" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble42.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("duplicated_blocks".equals(sonarQubeMetric.getKey())) {
                            atomicDouble43.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("duplicated_files".equals(sonarQubeMetric.getKey())) {
                            atomicDouble44.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("function_complexity".equals(sonarQubeMetric.getKey())) {
                            atomicDouble45.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_duplicated_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble46.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_duplicated_blocks".equals(sonarQubeMetric.getKey())) {
                            atomicDouble47.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble49.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("major_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble50.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_major_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble51.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("minor_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble52.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_minor_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble53.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("info_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble54.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_info_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble55.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("new_reliability_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble56.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                        }
                        if ("new_security_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble57.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                        }
                        if ("new_security_review_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble58.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                        }
                        if ("new_security_review_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble58.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                        }
                        if ("new_maintainability_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble59.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                        }
                        if ("new_violations".equals(sonarQubeMetric.getKey())) {
                            atomicDouble60.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("classes".equals(sonarQubeMetric.getKey())) {
                            atomicDouble61.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("files".equals(sonarQubeMetric.getKey())) {
                            atomicDouble62.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("functions".equals(sonarQubeMetric.getKey())) {
                            atomicDouble63.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                    }
                    catch (ParseException parseException) {
                        LOGGER.error("Error calculating aggregated measures : {}", (Object)parseException.getMessage());
                    }
                }));
            }
            atomicDouble23.set((atomicDouble26.get() - atomicDouble25.get() + atomicDouble27.get() - atomicDouble28.get()) / (atomicDouble26.get() + atomicDouble27.get()));
            if (Double.isNaN(atomicDouble23.get())) {
                atomicDouble23.set(0.0);
            }
            atomicDouble24.set((atomicDouble30.get() - atomicDouble29.get() + atomicDouble31.get() - atomicDouble32.get()) / (atomicDouble30.get() + atomicDouble31.get()));
            if (Double.isNaN(atomicDouble24.get())) {
                atomicDouble24.set(0.0);
            }
            hashMap2.put("lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble.get()));
            hashMap2.put("lines" + string2, FormatUtils.getNumber(this.userLocale).format(atomicDouble2.get()));
            hashMap2.put("size_rating", FormatUtils.toSizeRating(atomicDouble3.get()));
            hashMap2.put("bugs", FormatUtils.getNumber(this.userLocale).format(atomicDouble6.get()));
            hashMap2.put("bugs" + string4, FormatUtils.getNumber(this.userLocale).format(atomicDouble11));
            hashMap2.put("bugs" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble10));
            hashMap2.put("vulnerabilities", FormatUtils.getNumber(this.userLocale).format(atomicDouble12));
            hashMap2.put("vulnerabilities" + string4, FormatUtils.getNumber(this.userLocale).format(atomicDouble13));
            hashMap2.put("vulnerabilities" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble14));
            hashMap2.put("security_hotspots", FormatUtils.getNumber(this.userLocale).format(atomicDouble15));
            hashMap2.put("security_hotspots" + string4, FormatUtils.getNumber(this.userLocale).format(atomicDouble16));
            hashMap2.put("security_hotspots" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble17));
            hashMap2.put("code_smells", FormatUtils.getNumber(this.userLocale).format(atomicDouble18));
            hashMap2.put("code_smells" + string4, FormatUtils.getNumber().format(atomicDouble19));
            hashMap2.put("code_smells" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble20));
            double d2 = atomicDouble21.get() / (atomicDouble3.get() * 30.0);
            hashMap2.put("sqale_debt_ratio", FormatUtils.getPercentage(this.userLocale).format(d2));
            double d3 = d2 - (atomicDouble21.get() - atomicDouble22.get()) / ((atomicDouble3.get() - atomicDouble4.get()) * 30.0);
            hashMap2.put("sqale_debt_ratio" + string3, FormatUtils.getPercentage(this.userLocale).format(d3));
            double d4 = atomicDouble48.get() / (atomicDouble49.get() * 30.0);
            hashMap2.put("new_sqale_debt_ratio", FormatUtils.getPercentage(this.userLocale).format(d4));
            hashMap2.put("ncloc", FormatUtils.getNumber(this.userLocale).format(atomicDouble3.get()));
            hashMap2.put("ncloc" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble4.get()));
            hashMap2.put("duplicated_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble5.get()));
            hashMap2.put("duplicated_lines" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble7.get()));
            double d5 = atomicDouble5.get() / atomicDouble.get();
            double d6 = 1.0 - d5;
            hashMap2.put("duplicated_lines_density_value", FormatUtils.getNumber(Locale.US).format(d5 * 100.0));
            hashMap2.put("duplicated_lines_density_rest", FormatUtils.getNumber(Locale.US).format(d6 * 100.0));
            hashMap2.put("duplicated_lines_density", FormatUtils.getPercentage(this.userLocale).format(d5));
            double d7 = (atomicDouble5.get() + atomicDouble7.get()) / (atomicDouble.get() + atomicDouble2.get()) - d5;
            hashMap2.put("duplicated_lines_density" + string3, FormatUtils.getPercentage(this.userLocale).format(d7));
            double d8 = atomicDouble8.get() / atomicDouble.get();
            double d9 = 1.0 - d8;
            hashMap2.put("comment_lines_density_value", FormatUtils.getNumber(Locale.US).format(d8 * 100.0));
            hashMap2.put("comment_lines_density_rest", FormatUtils.getNumber(Locale.US).format(d9 * 100.0));
            hashMap2.put("comment_lines_density", FormatUtils.getPercentage(this.userLocale).format(d8));
            double d10 = d8 - (atomicDouble8.get() - atomicDouble9.get()) / (atomicDouble.get() - atomicDouble2.get());
            hashMap2.put("comment_lines_density" + string3, FormatUtils.getPercentage(this.userLocale).format(d10));
            double d11 = atomicDouble23.get();
            double d12 = 1.0 - d11;
            hashMap2.put("coverage_value", FormatUtils.getNumber(Locale.US).format(d11 * 100.0));
            hashMap2.put("coverage_rest", FormatUtils.getNumber(Locale.US).format(d12 * 100.0));
            hashMap2.put("coverage", FormatUtils.getPercentage(this.userLocale).format(d11));
            hashMap2.put("coverage" + string3, FormatUtils.getPercentage(this.userLocale).format(atomicDouble24.get()));
            atomicDouble33.set(atomicDouble33.get() / (double)list.size());
            atomicDouble34.set(atomicDouble34.get() / (double)list.size());
            atomicDouble35.set(atomicDouble35.get() / (double)list.size());
            atomicDouble36.set(atomicDouble36.get() / (double)list.size());
            atomicDouble56.set(atomicDouble56.get() / (double)list.size());
            atomicDouble57.set(atomicDouble57.get() / (double)list.size());
            atomicDouble58.set(atomicDouble58.get() / (double)list.size());
            atomicDouble59.set(atomicDouble59.get() / (double)list.size());
            hashMap2.put("reliability_rating", FormatUtils.doubleToRating(atomicDouble33.get()));
            hashMap2.put("security_rating", FormatUtils.doubleToRating(atomicDouble34.get()));
            hashMap2.put("security_review_rating", FormatUtils.doubleToRating(atomicDouble35.get()));
            hashMap2.put("sqale_rating", FormatUtils.doubleToRating(atomicDouble36.get()));
            hashMap2.put("duplicated_lines_rating", FormatUtils.duplicatedLinesToRating(d5 * 100.0));
            hashMap2.put("coverage_rating", FormatUtils.coverageToRating(d11 * 100.0));
            hashMap2.put("new_reliability_rating", FormatUtils.doubleToRating(atomicDouble56.get()));
            hashMap2.put("new_security_rating", FormatUtils.doubleToRating(atomicDouble34.get()));
            hashMap2.put("new_security_review_rating", FormatUtils.doubleToRating(atomicDouble58.get()));
            hashMap2.put("new_maintainability_rating", FormatUtils.doubleToRating(atomicDouble59.get()));
            hashMap2.put("blocker_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble39.get()));
            hashMap2.put("classes", FormatUtils.getNumber(this.userLocale).format(atomicDouble61.get()));
            hashMap2.put("conditions_to_cover", FormatUtils.getNumber(this.userLocale).format(atomicDouble26.get()));
            hashMap2.put("comment_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble8.get()));
            hashMap2.put("complexity", FormatUtils.getNumber(this.userLocale).format(atomicDouble37.get()));
            hashMap2.put("critical_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble41.get()));
            hashMap2.put("files", FormatUtils.getNumber(this.userLocale).format(atomicDouble62.get()));
            hashMap2.put("functions", FormatUtils.getNumber(this.userLocale).format(atomicDouble63.get()));
            hashMap2.put("function_complexity", FormatUtils.getNumber(this.userLocale).format(atomicDouble45.get()));
            hashMap2.put("violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble38.get()));
            hashMap2.put("major_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble50.get()));
            hashMap2.put("minor_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble52.get()));
            hashMap2.put("info_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble54.get()));
            hashMap2.put("lines_to_cover", FormatUtils.getNumber(this.userLocale).format(atomicDouble27.get()));
            hashMap2.put("sqale_index", WorkDuration.format(WorkDuration.create(atomicDouble21.longValue())));
            hashMap2.put("uncovered_conditions", FormatUtils.getNumber(this.userLocale).format(atomicDouble25.get()));
            hashMap2.put("uncovered_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble28.get()));
            hashMap2.put("duplicated_blocks", FormatUtils.getNumber(this.userLocale).format(atomicDouble43.get()));
            hashMap2.put("duplicated_files", FormatUtils.getNumber(this.userLocale).format(atomicDouble44.get()));
            hashMap2.put("new_blocker_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble40.get()));
            hashMap2.put("new_bugs", FormatUtils.getNumber(this.userLocale).format(atomicDouble10.get()));
            hashMap2.put("new_code_smells", FormatUtils.getNumber(this.userLocale).format(atomicDouble20.get()));
            hashMap2.put("new_conditions_to_cover", FormatUtils.getNumber(this.userLocale).format(atomicDouble30.get()));
            double d13 = atomicDouble24.get();
            hashMap2.put("new_coverage", FormatUtils.getPercentage(this.userLocale).format(d13));
            hashMap2.put("new_critical_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble42.get()));
            hashMap2.put("new_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble60.get()));
            hashMap2.put("new_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble49.get()));
            hashMap2.put("new_lines_to_cover", FormatUtils.getNumber(this.userLocale).format(atomicDouble31.get()));
            hashMap2.put("new_major_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble51.get()));
            hashMap2.put("new_minor_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble53.get()));
            hashMap2.put("new_info_violations", FormatUtils.getNumber(this.userLocale).format(atomicDouble55.get()));
            hashMap2.put("new_security_hotspots", FormatUtils.getNumber(this.userLocale).format(atomicDouble17.get()));
            hashMap2.put("new_technical_debt", WorkDuration.format(WorkDuration.create(atomicDouble48.longValue())));
            hashMap2.put("new_uncovered_conditions", FormatUtils.getNumber(this.userLocale).format(atomicDouble29.get()));
            hashMap2.put("new_uncovered_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble32.get()));
            hashMap2.put("new_vulnerabilities", FormatUtils.getNumber(this.userLocale).format(atomicDouble14.get()));
            double d14 = atomicDouble46.get() / atomicDouble49.get();
            hashMap2.put("new_duplicated_lines_density", FormatUtils.getPercentage(this.userLocale).format(d14));
            hashMap2.put("new_duplicated_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble46.get()));
            hashMap2.put("new_duplicated_blocks", FormatUtils.getNumber(this.userLocale).format(atomicDouble47.get()));
            hashMap.put("reliability_rating_distribution", map);
            hashMap.put("security_rating_distribution", map2);
            hashMap.put("security_review_rating_distribution", map3);
            hashMap.put("sqale_rating_distribution", map4);
            hashMap.put("size_rating_distribution", map5);
            hashMap.put("duplicated_lines_rating_distribution", map6);
            hashMap.put("coverage_rating_distribution", map7);
        }
        catch (HttpException httpException) {
            LOGGER.error("Error HTTP getting aggregated measures from ({}) with metrics ({}) ", (Object)list, (Object)list2);
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error("Error getting aggregated measures from ({}) with metrics ({}) ", (Object)list, (Object)list2);
            throw new SonarQubeException(String.format("Error getting aggregated measures: %s", exception.getMessage()), exception);
        }
        hashMap.put("aggregatedMeasuresMap", hashMap2);
        return hashMap;
    }

    private List<SonarQubeMeasure> getMeasures(String string, List<String> list) throws SonarQubeException {
        return this.getMeasures(Collections.singletonList(string), list);
    }

    private List<SonarQubeMeasure> getMeasures(List<String> list, String string, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeMeasure> arrayList = new ArrayList<SonarQubeMeasure>();
        Map<String, Metric> map = SonarQubeMetricManager.getMetrics(this.wsClient);
        try {
            list.forEach(string2 -> {
                LOGGER.debug("getting measures for {}", string2);
                ArrayList<SonarQubeMetric> arrayList = new ArrayList<SonarQubeMetric>();
                ComponentRequest componentRequest = new ComponentRequest();
                componentRequest.setMetricKeys(list2.stream().distinct().collect(Collectors.toList()));
                componentRequest.setComponent((String)string2);
                componentRequest.setAdditionalFields(Arrays.asList("periods"));
                if (string != null && !string.isEmpty()) {
                    componentRequest.setBranch(string);
                }
                LOGGER.debug("Component Request is ready...");
                Measures.ComponentWsResponse componentWsResponse = this.wsClient.measures().component(componentRequest);
                LOGGER.debug("Component Request done!");
                componentWsResponse.getComponent().getMeasuresList().forEach(measure -> {
                    ArrayList<SonarQubeMeasure> arrayList = measure.getPeriods() == null ? Collections.emptyList() : measure.getPeriods().getPeriodsValueList();
                    String string = ((Metric)map.get(measure.getMetric())).getType();
                    SonarQubeMetric sonarQubeMetric = new SonarQubeMetric();
                    sonarQubeMetric.setKey(measure.getMetric());
                    sonarQubeMetric.setType(string);
                    LOGGER.debug("Processing metric: {} ... type {}", (Object)measure.getMetric(), (Object)string);
                    if ("ncloc".equals(measure.getMetric())) {
                        Object object = new SonarQubeMetric();
                        ((SonarQubeMetric)object).setKey("size_rating");
                        ((SonarQubeMetric)object).setValue(FormatUtils.toSizeRating(measure.getValue()));
                        ((SonarQubeMetric)object).setType(string);
                        arrayList.add((SonarQubeMetric)object);
                    }
                    switch (sonarQubeMetric.getType()) {
                        case "PERCENT": {
                            SonarQubeMetric sonarQubeMetric2;
                            double d2 = 0.0;
                            if (!measure.getValue().isEmpty()) {
                                d2 = Double.parseDouble(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                d2 = Double.parseDouble(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            double d3 = 100.0 - d2;
                            if ("duplicated_lines_density".equals(sonarQubeMetric.getKey())) {
                                sonarQubeMetric2 = new SonarQubeMetric();
                                sonarQubeMetric2.setKey("duplicated_lines_rating");
                                sonarQubeMetric2.setValue(FormatUtils.duplicatedLinesToRating(d2));
                                sonarQubeMetric2.setType(string);
                                arrayList.add(sonarQubeMetric2);
                            }
                            if ("coverage".equals(sonarQubeMetric.getKey())) {
                                sonarQubeMetric2 = new SonarQubeMetric();
                                sonarQubeMetric2.setKey("coverage_rating");
                                sonarQubeMetric2.setValue(FormatUtils.coverageToRating(d2));
                                sonarQubeMetric2.setType(string);
                                arrayList.add(sonarQubeMetric2);
                            }
                            sonarQubeMetric.setValue(FormatUtils.getNumber(this.userLocale).format(d2));
                            sonarQubeMetric2 = new SonarQubeMetric();
                            sonarQubeMetric2.setKey(sonarQubeMetric.getKey() + VALUE);
                            sonarQubeMetric2.setValue(FormatUtils.getNumber(Locale.US).format(d2));
                            sonarQubeMetric2.setType(sonarQubeMetric.getType());
                            arrayList.add(sonarQubeMetric2);
                            SonarQubeMetric sonarQubeMetric3 = new SonarQubeMetric();
                            sonarQubeMetric3.setKey(sonarQubeMetric.getKey() + REST);
                            sonarQubeMetric3.setValue(FormatUtils.getNumber(Locale.US).format(d3));
                            sonarQubeMetric3.setType(sonarQubeMetric.getType());
                            arrayList.add(sonarQubeMetric3);
                            arrayList.forEach(periodValue -> {
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.getPercentage(this.userLocale).format(Double.parseDouble(periodValue.getValue()) / 100.0), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "RATING": {
                            sonarQubeMetric.setValue("A");
                            if (!measure.getValue().isEmpty()) {
                                sonarQubeMetric.setValue(FormatUtils.toRating(measure.getValue()));
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                sonarQubeMetric.setValue(FormatUtils.toRating(((Measures.PeriodValue)arrayList.get(0)).getValue()));
                            }
                            arrayList.forEach(periodValue -> {
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.toRating(periodValue.getValue()), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "WORK_DUR": {
                            long l = 0L;
                            if (!measure.getValue().isEmpty()) {
                                l = Long.parseLong(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                l = Long.parseLong(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            WorkDuration workDuration = WorkDuration.create(l);
                            sonarQubeMetric.setValue(WorkDuration.format(workDuration));
                            arrayList.forEach(periodValue -> {
                                long l = Long.parseLong(periodValue.getValue());
                                WorkDuration workDuration = WorkDuration.create(l);
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), WorkDuration.format(workDuration), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "INT": {
                            int n = 0;
                            if (!measure.getValue().isEmpty()) {
                                n = Integer.parseInt(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                n = Integer.parseInt(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            sonarQubeMetric.setValue(FormatUtils.getNumber(this.userLocale).format(n));
                            arrayList.forEach(periodValue -> {
                                int n = periodValue.getValue().isEmpty() ? 0 : Integer.parseInt(periodValue.getValue());
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.getNumber(this.userLocale).format(n), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "FLOAT": {
                            double d4 = 0.0;
                            if (!measure.getValue().isEmpty()) {
                                d4 = Double.parseDouble(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                d4 = Double.parseDouble(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            sonarQubeMetric.setValue(FormatUtils.getNumber(this.userLocale).format(d4));
                            arrayList.forEach(periodValue -> {
                                double d2 = periodValue.getValue().isEmpty() ? 0.0 : Double.parseDouble(periodValue.getValue());
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.getNumber(this.userLocale).format(d2), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        default: {
                            sonarQubeMetric.setValue(measure.getValue());
                        }
                    }
                    arrayList.add(sonarQubeMetric);
                });
                SonarQubeMeasure sonarQubeMeasure = new SonarQubeMeasure();
                sonarQubeMeasure.setComponentKey((String)string2);
                sonarQubeMeasure.setComponentName(componentWsResponse.getComponent().getName());
                sonarQubeMeasure.setSonarQubeMetricList(arrayList);
                arrayList.add(sonarQubeMeasure);
            });
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting measures from (%s), with metrics (%s) ", list, list2));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting measures from (%s), with metrics (%s) ", list, list2));
            throw new SonarQubeException(String.format("Error getting measures: %s", exception.getMessage()));
        }
        SonarQubeMeasureManager.printMeasuresMap(arrayList);
        return arrayList;
    }

    private Map<String, Integer> processDistribution(Map<String, Integer> map, SonarQubeMetric sonarQubeMetric) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = map.get(sonarQubeMetric.getValue()) == null ? 0 : map.get(sonarQubeMetric.getValue());
        hashMap.put(sonarQubeMetric.getValue(), n + 1);
        return hashMap;
    }

    private Map<String, Integer> createDistributionMap(List<String> list, int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        list.forEach(string -> hashMap.put((String)string, n));
        return hashMap;
    }

    private SonarQubeMetric createSonarQubeMetric(String string, String string2, String string3) {
        SonarQubeMetric sonarQubeMetric = new SonarQubeMetric();
        sonarQubeMetric.setKey(string);
        sonarQubeMetric.setValue(string3);
        sonarQubeMetric.setType(string2);
        LOGGER.debug("{}   value: {}", (Object)sonarQubeMetric.getKey(), (Object)sonarQubeMetric.getValue());
        return sonarQubeMetric;
    }

    private SonarQubeMetric createPeriodMetric(String string, String string2, String string3, int n) {
        return this.createSonarQubeMetric(string + "-period" + n, string2, string3);
    }

    private static void printMeasuresMap(List<SonarQubeMeasure> list) {
        list.forEach(sonarQubeMeasure -> sonarQubeMeasure.getSonarQubeMetricList().forEach(sonarQubeMetric -> LOGGER.debug("Metric Key: {} ... Metric Value: {}", (Object)sonarQubeMetric.getKey(), (Object)sonarQubeMetric.getValue())));
    }

    public SonarQubeHistoryMeasure getHistoryMeasures(String string, String string2, List<String> list, String string3) throws SonarQubeException {
        SonarQubeHistoryMeasure sonarQubeHistoryMeasure = new SonarQubeHistoryMeasure();
        HashMap<String, List<SonarQubeHistoryMetricValue>> hashMap = new HashMap<String, List<SonarQubeHistoryMetricValue>>();
        try {
            LOGGER.debug("getting history measures for {}", (Object)string);
            SearchHistoryRequest searchHistoryRequest = SonarQubeMeasureManager.createSearchHistoryRequest(string2, list, string, string3, 1);
            LOGGER.debug("Search History Request is ready...");
            Measures.SearchHistoryResponse searchHistoryResponse = this.wsClient.measures().searchHistory(searchHistoryRequest);
            LOGGER.debug("Search History Response  done!");
            ArrayList<Measures.SearchHistoryResponse.HistoryMeasure> arrayList = new ArrayList<Measures.SearchHistoryResponse.HistoryMeasure>(searchHistoryResponse.getMeasuresList());
            if (this.responseHasPagingAndMoreItemsThanPageSize(searchHistoryResponse)) {
                int n = (int)Math.floor((double)searchHistoryResponse.getPaging().getTotal() / (double)searchHistoryResponse.getPaging().getPageSize()) + 1;
                for (int i = 2; i <= n; ++i) {
                    searchHistoryRequest = SonarQubeMeasureManager.createSearchHistoryRequest(string2, list, string, string3, i);
                    searchHistoryRequest.setPs(HISTORY_MEASURE_PAGE_SIZE_PARAM);
                    searchHistoryRequest.setP(Integer.toString(i));
                    searchHistoryResponse = this.wsClient.measures().searchHistory(searchHistoryRequest);
                    arrayList.addAll(searchHistoryResponse.getMeasuresList());
                }
            }
            hashMap.putAll(this.getHistoryMeasuresMapList(arrayList));
            sonarQubeHistoryMeasure.setComponentKey(string);
            sonarQubeHistoryMeasure.setHistoryMetricMapValues(hashMap);
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting history measures from (%s), with metrics (%s) ", string, list));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting history measures from (%s), with metrics (%s) ", string, list));
            throw new SonarQubeException(String.format("Error getting history measures: %s", exception));
        }
        return sonarQubeHistoryMeasure;
    }

    private Map<String, List<SonarQubeHistoryMetricValue>> getHistoryMeasuresMapList(List<Measures.SearchHistoryResponse.HistoryMeasure> list) {
        HashMap<String, List<SonarQubeHistoryMetricValue>> hashMap = new HashMap<String, List<SonarQubeHistoryMetricValue>>();
        for (Measures.SearchHistoryResponse.HistoryMeasure historyMeasure : list) {
            ArrayList<SonarQubeHistoryMetricValue> arrayList = new ArrayList<SonarQubeHistoryMetricValue>();
            String string = historyMeasure.getMetric();
            List<Measures.SearchHistoryResponse.HistoryValue> list2 = historyMeasure.getHistoryList();
            for (Measures.SearchHistoryResponse.HistoryValue historyValue : list2) {
                SonarQubeHistoryMetricValue sonarQubeHistoryMetricValue = new SonarQubeHistoryMetricValue();
                sonarQubeHistoryMetricValue.setDate(historyValue.getDate());
                sonarQubeHistoryMetricValue.setValue(historyValue.getValue());
                sonarQubeHistoryMetricValue.setMetricKey(string);
                arrayList.add(sonarQubeHistoryMetricValue);
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    private boolean responseHasPagingAndMoreItemsThanPageSize(Measures.SearchHistoryResponse searchHistoryResponse) {
        return searchHistoryResponse.hasPaging() && searchHistoryResponse.getPaging().getTotal() > searchHistoryResponse.getPaging().getPageSize();
    }

    private static SearchHistoryRequest createSearchHistoryRequest(String string, List<String> list, String string2, String string3, int n) {
        SearchHistoryRequest searchHistoryRequest = new SearchHistoryRequest();
        if (ParamsUtils.hasValue(string)) {
            searchHistoryRequest.setBranch(string);
        }
        searchHistoryRequest.setMetrics(list.stream().distinct().collect(Collectors.toList()));
        searchHistoryRequest.setComponent(string2);
        searchHistoryRequest.setP(Integer.toString(n));
        searchHistoryRequest.setPs(HISTORY_MEASURE_PAGE_SIZE_PARAM);
        if (ParamsUtils.hasValue(string3)) {
            searchHistoryRequest.setFrom(string3);
        }
        return searchHistoryRequest;
    }
}

